/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.uriresolvermanager;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portlets.user.uriresolvermanager.entity.Resolver;
import org.gcube.portlets.user.uriresolvermanager.entity.ServiceAccessPoint;
import org.gcube.portlets.user.uriresolvermanager.entity.ServiceParameter;
import org.gcube.portlets.user.uriresolvermanager.exception.IllegalArgumentException;
import org.gcube.portlets.user.uriresolvermanager.exception.UriResolverMapException;
import org.gcube.portlets.user.uriresolvermanager.readers.RuntimeResourceReader;
import org.gcube.portlets.user.uriresolvermanager.readers.UriResolverMapReader;
import org.gcube.portlets.user.uriresolvermanager.util.UrlEncoderUtil;
import org.gcube.portlets.user.urlshortener.UrlShortener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriResolverManager {
    public static int RESET_DELAY;
    public static int RESET_TIME;
    private UriResolverMapReader uriResolverMapReader;
    private Map<String, Resolver> applicationTypes;
    private String scope;
    private String applicationType;
    private RuntimeResourceReader reader;
    private int usingReader = 0;
    private ServiceAccessPoint serviceAccessPoint;
    private Timer timer;
    public static final Logger logger;

    public synchronized void lockReader() {
        ++this.usingReader;
    }

    public synchronized void releaseReader() {
        --this.usingReader;
    }

    public synchronized int countReaders() {
        return this.usingReader;
    }

    public UriResolverManager() throws UriResolverMapException, IllegalArgumentException {
        try {
            this.scope = ScopeProvider.instance.get();
            if (this.scope == null) {
                throw new UriResolverMapException("Scope is null, set scope provider!");
            }
            this.uriResolverMapReader = new UriResolverMapReader(this.scope);
            this.applicationTypes = this.uriResolverMapReader.getApplicationTypes();
            this.setTimerUriResolverReader(RESET_DELAY, RESET_TIME);
        }
        catch (UriResolverMapException e) {
            logger.error("UriResolverMapException: ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("UriResolverManager: ", (Throwable)e);
            throw new UriResolverMapException("Map Application Type - Resources not found in IS");
        }
    }

    public void setApplicationType(String applicationType) throws IllegalArgumentException {
        if (!this.applicationTypes.containsKey(applicationType)) {
            throw new IllegalArgumentException("Application type '" + applicationType + "' not found in Application Types: " + this.getApplicationTypes());
        }
        this.applicationType = applicationType;
    }

    public UriResolverManager(String applicationType) throws UriResolverMapException, IllegalArgumentException {
        this();
        this.setApplicationType(applicationType);
    }

    public String getLink(String applicationType, Map<String, String> parameters, boolean shortLink) throws IllegalArgumentException, UriResolverMapException {
        this.applicationType = applicationType;
        return this.getLink(parameters, shortLink);
    }

    public String getLink(Map<String, String> parameters, boolean shortLink) throws IllegalArgumentException, UriResolverMapException {
        String link;
        if (this.applicationType == null) {
            throw new IllegalArgumentException("Application type is null");
        }
        Resolver resolver = this.applicationTypes.get(this.applicationType);
        if (parameters == null) {
            throw new IllegalArgumentException("Input Map parameters is null");
        }
        try {
            this.lockReader();
            if (this.reader == null) {
                logger.info("Runtime Resource Reader is null, istancing...");
                ScopeProvider.instance.set(this.scope);
                this.reader = new RuntimeResourceReader(this.scope, resolver.getResourceName());
            }
            if (resolver.getEntryName() == null || resolver.getEntryName().isEmpty()) {
                logger.warn("The entryname to " + resolver.getResourceName() + " is null or empty, reading first Access Point!!");
                this.serviceAccessPoint = this.reader.getServiceAccessPoints().get(0);
            } else {
                logger.warn("Reading Access Point for Entry Name: " + resolver.getEntryName());
                this.serviceAccessPoint = this.reader.getServiceAccessPointForEntryName(resolver.getEntryName());
                if (this.serviceAccessPoint == null) {
                    throw new UriResolverMapException("Entry Name " + resolver.getEntryName() + " not found in Resource name: " + resolver.getResourceName());
                }
            }
            List<ServiceParameter> resourceParameters = this.serviceAccessPoint.getServiceParameters();
            for (ServiceParameter serviceParameter : resourceParameters) {
                if (!serviceParameter.isMandatory() || parameters.containsKey(serviceParameter.getKey())) continue;
                throw new IllegalArgumentException("Mandatory service key (parameter) '" + serviceParameter.getKey() + "' not found into input map");
            }
            String baseURI = this.serviceAccessPoint.getServiceUrl();
            this.releaseReader();
            String params = UrlEncoderUtil.encodeQuery(parameters);
            link = baseURI + "?" + params;
            logger.info("Created HTTP URI request (link): " + link);
            if (shortLink) {
                try {
                    logger.info("Shortner start..");
                    UrlShortener shortener = new UrlShortener(this.scope);
                    link = shortener.shorten(link);
                    logger.info("Shorted link is: " + link);
                }
                catch (Exception e) {
                    logger.warn("An error occurred on shortener the link ", (Throwable)e);
                }
            }
        }
        catch (IllegalArgumentException e) {
            logger.error("Uri Resolver IllegalArgumentException: ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Uri Resolver Exception: ", (Throwable)e);
            throw new UriResolverMapException("Uri Resolver error: " + e.getMessage());
        }
        return link;
    }

    public Set<String> getApplicationTypes() {
        return this.applicationTypes.keySet();
    }

    public List<ServiceParameter> discoveryServiceParameters(Resolver resolver) throws IllegalArgumentException, Exception {
        try {
            if (this.scope == null) {
                throw new IllegalArgumentException("Scope is null, set ScopeProvider");
            }
            if (resolver == null) {
                throw new IllegalArgumentException("Resolver is null, set Resolver");
            }
            RuntimeResourceReader reader = new RuntimeResourceReader(this.scope, resolver.getResourceName());
            ServiceAccessPoint serviceAccessPoint = null;
            if (resolver.getEntryName() == null || resolver.getEntryName().isEmpty()) {
                logger.warn("The entryname to " + resolver.getResourceName() + " is null or empty, reading first Access Point!!");
                serviceAccessPoint = reader.getServiceAccessPoints().get(0);
            } else {
                logger.info("Reading Access Point for entryname: " + resolver.getEntryName());
                serviceAccessPoint = reader.getServiceAccessPointForEntryName(resolver.getEntryName());
                if (serviceAccessPoint == null) {
                    throw new UriResolverMapException("Entry Name " + resolver.getEntryName() + " not found in Resource name: " + resolver.getResourceName());
                }
            }
            return serviceAccessPoint.getServiceParameters();
        }
        catch (Exception e) {
            logger.error("Uri Resolver error: ", (Throwable)e);
            throw new UriResolverMapException("Uri Resolver error: " + e.getMessage());
        }
    }

    public Resolver getResolver(String applicationType) {
        return this.applicationTypes.get(applicationType);
    }

    public Map<String, Resolver> getCapabilities() {
        return this.applicationTypes;
    }

    public void setTimerUriResolverReader(long delay, long period) {
        this.cancelTimerUriResolverReader();
        this.timer = new Timer(true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                logger.info("Timer Reset Runtime Resource running..");
                int counters = UriResolverManager.this.countReaders();
                if (counters == 0) {
                    logger.info("Reader not locked, resetting");
                    UriResolverManager.this.reader = null;
                } else {
                    logger.info("Reader locked, counters is/are:" + counters + ", skipping");
                }
            }
        }, delay, period);
    }

    public void cancelTimerUriResolverReader() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void invalidUriResolverReader() {
        this.reader = null;
    }

    static {
        RESET_TIME = RESET_DELAY = 900000;
        logger = LoggerFactory.getLogger(UriResolverManager.class);
    }
}

