/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.uriresolvermanager.readers;

import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.common.resources.gcore.utils.XPathHelper;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portlets.user.uriresolvermanager.entity.Resolver;
import org.gcube.portlets.user.uriresolvermanager.readers.ApplicationProfileException;
import org.gcube.portlets.user.uriresolvermanager.util.ScopeUtil;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.QueryBox;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class UriResolverMapReader {
    public static final String URIRESOLVERMAP_SECONDARY_TYPE = "UriResolverMap";
    public static final String URI_RESOLVER_MAP_RESOURCE_NAME = "Uri-Resolver-Map";
    private Logger logger = LoggerFactory.getLogger(UriResolverMapReader.class);
    private String secondaryType;
    private String scope;
    private String resourceName;
    private Map<String, Resolver> applicationTypes;

    public UriResolverMapReader(String scope) throws Exception {
        this.scope = scope;
        if (scope == null) {
            throw new Exception("Scope is null, set scope provider!");
        }
        this.resourceName = URI_RESOLVER_MAP_RESOURCE_NAME;
        this.secondaryType = URIRESOLVERMAP_SECONDARY_TYPE;
        this.readProfileFromInfrastrucure();
    }

    private void readProfileFromInfrastrucure() throws Exception {
        String queryString = UriResolverMapReader.getGcubeGenericQueryString(this.secondaryType, this.resourceName);
        this.logger.info("Trying to fetch applicationProfile profile from the infrastructure for " + this.secondaryType + " scope: " + this.scope);
        this.logger.info(queryString);
        try {
            String infra = ScopeUtil.getInfrastructureNameFromScope(this.scope);
            ScopeProvider.instance.set(infra);
            this.logger.info("scope provider set instance: " + infra);
            QueryBox q = new QueryBox(queryString);
            DiscoveryClient client = ICFactory.client();
            List appUriResolverMap = client.submit((Query)q);
            if (appUriResolverMap == null || appUriResolverMap.size() == 0) {
                throw new ApplicationProfileException("Your applicationProfile with secondaryType: " + this.secondaryType + " and name " + this.resourceName + " is not registered in the infrastructure");
            }
            String elem = (String)appUriResolverMap.get(0);
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Element node = docBuilder.parse(new InputSource(new StringReader(elem))).getDocumentElement();
            XPathHelper helper = new XPathHelper((Node)node);
            List currValue = null;
            currValue = helper.evaluate("/Resource/Profile/Body/access_point/application_type/text()");
            if (currValue != null && currValue.size() > 0) {
                this.logger.info("Application Types are: " + currValue.size());
                this.applicationTypes = new HashMap<String, Resolver>(currValue.size());
                for (String at : currValue) {
                    this.logger.info("Application Type " + at);
                    List resources = helper.evaluate("/Resource/Profile/Body/access_point[application_type='" + at + "']/resource/text()");
                    List entryNames = helper.evaluate("/Resource/Profile/Body/access_point[application_type='" + at + "']/entryname/text()");
                    if (resources != null && resources.size() > 0) {
                        Resolver resolver = new Resolver((String)resources.get(0), (String)entryNames.get(0));
                        this.applicationTypes.put(at, resolver);
                        this.logger.info("Stored: " + at + " -> Resolver: " + resolver);
                        continue;
                    }
                    this.logger.warn("Skipping Type " + at + " mapping to runtime resource not found!");
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error while trying to fetch applicationProfile with secondaryType: " + this.secondaryType + " and name " + this.resourceName + " from the infrastructure", (Throwable)e);
            throw new ApplicationProfileException("Error while trying to fetch applicationProfile with secondaryType: " + this.secondaryType + " and name " + this.resourceName + " from the infrastructure");
        }
    }

    public static String getGcubeGenericQueryString(String secondaryType, String name) {
        return "for $profile in collection('/db/Profiles/GenericResource')//Resource where $profile/Profile/SecondaryType/string() eq '" + secondaryType + "' and  $profile/Profile/Name/string() " + " eq '" + name + "'" + "return $profile";
    }

    public Map<String, Resolver> getApplicationTypes() {
        return this.applicationTypes;
    }

    public String getSecondaryType() {
        return this.secondaryType;
    }

    public String getScope() {
        return this.scope;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UriResolverMapReader [secondaryType=");
        builder.append(this.secondaryType);
        builder.append(", scope=");
        builder.append(this.scope);
        builder.append(", resourceName=");
        builder.append(this.resourceName);
        builder.append(", applicationTypes=");
        builder.append(this.applicationTypes);
        builder.append("]");
        return builder.toString();
    }
}

