/**
 * 
 */
package org.gcube.portlets.user.warmanagementwidget.client.upload;

import org.gcube.portlets.user.warmanagementwidget.client.progress.OperationProgressListener;
import org.gcube.portlets.user.warmanagementwidget.client.progress.OperationProgressUpdater;
import org.gcube.portlets.user.warmanagementwidget.client.rpc.WarManagementService;
import org.gcube.portlets.user.warmanagementwidget.client.upload.progress.CreateProgressBarUpdater;
import org.gcube.portlets.user.warmanagementwidget.client.upload.progress.CreateProgressSource;
import org.gcube.portlets.user.warmanagementwidget.client.util.ErrorMessageBox;
import org.gcube.portlets.user.warmanagementwidget.client.wizard.WizardCard;

import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.ProgressBar;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;


/**
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public class WarStoreCard extends WizardCard {
	
	public static final int STATUS_POLLING_DELAY = 1000;
	
	protected WarImportSession session;
	protected OperationProgressUpdater progressUpdater;


	public WarStoreCard(WarImportSession session)
	{
		//FIXME step message calculated
		super("War Upload", "Step 4 of 4");

		this.session = session;
		
		setContent(getPanel());
	}

	public FormPanel getPanel()
	{
		FormData formData = new FormData("-20");
		FormPanel panel = new FormPanel();
		panel.setHeaderVisible(false);

		Label progressLabel = new Label("Import progress");
		panel.add(progressLabel);
		
		CreateProgressSource progressSource = new CreateProgressSource(session);
		progressUpdater = new OperationProgressUpdater(progressSource);
		
		ProgressBar importProgess = new ProgressBar();
		progressUpdater.addListener(new CreateProgressBarUpdater(importProgess));
		
		panel.add(importProgess, formData);
		
		
		panel.add(new HTML("<br>"));
		
		final Button errorDetailsButton = new Button("Error details");
		errorDetailsButton.setVisible(false);
		panel.add(errorDetailsButton);
		
		progressUpdater.addListener(new OperationProgressListener() {
			
			@Override
			public void operationUpdate(long total, long elaborated) {}
			
			@Override
			public void operationFailed(Throwable caught, String reason, final String failureDetails) {
				errorDetailsButton.setVisible(true);
				
				//not a good way
				errorDetailsButton.addSelectionListener(new SelectionListener<ButtonEvent>() {
					
					@Override
					public void componentSelected(ButtonEvent ce) {
						ErrorMessageBox.showErrorDetails("Error details", failureDetails);
						
					}
				});
			}
			
			@Override
			public void operationComplete() {
				setEnableNextButton(true);		
			}
		});
		
		
		return panel;
	}
	
	public void createWar()
	{
		WarManagementService.Util.getInstance().uploadWar(session.getId(), session.getProfile(), GWT.getModuleBaseURL(), new AsyncCallback<Void>() {
			
			@Override
			public void onSuccess(Void result) {
				progressUpdater.scheduleRepeating(STATUS_POLLING_DELAY);
			}
			
			@Override
			public void onFailure(Throwable caught) {
				showErrorAndHide("An error occured requiring to store the WAR", "Error: "+caught.toString());
				
			}
		});
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setup() {
		setEnableBackButton(false);
		setNextButtonText("Close");
		setEnableNextButton(false);
		createWar();
		setNextButtonToFinish();
	}
	
}
