/**
 * 
 */
package org.gcube.portlets.user.warmanagementwidget.client.upload.progress;

import org.gcube.portlets.user.warmanagementwidget.client.progress.OperationProgressListener;

import com.extjs.gxt.ui.client.widget.ProgressBar;

/**
 * Updates a {@link ProgressBar} progress and text based on {@link OperationProgressListener} events.
 * @author Federico De Faveri defaveri@isti.cnr.it
 */
public class CreateProgressBarUpdater implements OperationProgressListener {
	
	protected ProgressBar progressBar;

	/**
	 * Creates a new {@link ProgressBar} updater.
	 * @param progressBar the {@link ProgressBar} to update.
	 */
	public CreateProgressBarUpdater(ProgressBar progressBar) {
		this.progressBar = progressBar;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void operationUpdate(long total, long elaborated) {
		switch ((int)elaborated) {
			case CreationStates.CREATE_STATE_PROFILE_CREATION: progressBar.updateProgress(0.25, "creating the Profile..."); break;
			case CreationStates.CREATE_STATE_DEPLOYING_WAR: progressBar.updateProgress(0.5, "storing the WAR on Maven Repository..."); break;
			case CreationStates.CREATE_STATE_STORING_PROFILE: progressBar.updateProgress(0.75, "storing the profile on Software Gateway..."); break;
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void operationComplete() {
		progressBar.updateProgress(1, "Creation complete.");
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void operationFailed(Throwable caught, String reason, String failureDetails) {
		progressBar.updateText("Creation failed: "+reason);
	}

}
