/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.widgets.fileupload.server;

import org.apache.commons.fileupload.ProgressListener;
import org.gcube.portlets.widgets.fileupload.server.UploadProgress;
import org.gcube.portlets.widgets.fileupload.shared.event.Event;
import org.gcube.portlets.widgets.fileupload.shared.event.UploadProgressChangeEvent;

public final class UploadProgressListener
implements ProgressListener {
    private static final double COMPLETE_PERECENTAGE = 100.0;
    private int percentage = -1;
    private String fileName;
    private String absolutePath;
    private UploadProgress uploadProgress;

    public UploadProgressListener(String fileName, UploadProgress uploadProgress, String absolutePath) {
        this.fileName = fileName;
        this.uploadProgress = uploadProgress;
        this.absolutePath = absolutePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long bytesRead, long totalBytes, int items) {
        int percentage = (int)Math.floor((double)bytesRead / (double)totalBytes * 100.0);
        if (this.percentage == percentage) {
            return;
        }
        this.percentage = percentage;
        UploadProgressChangeEvent event = new UploadProgressChangeEvent();
        event.setFilename(this.fileName);
        event.setPercentage(Integer.valueOf(percentage));
        event.setAbsolutePath(this.absolutePath);
        UploadProgress uploadProgress = this.uploadProgress;
        synchronized (uploadProgress) {
            this.uploadProgress.add((Event)event);
            this.uploadProgress.notifyAll();
        }
    }
}

