package org.gcube.portlets.widgets.pickitem.client.events;

import org.gcube.portlets.widgets.pickitem.shared.ItemBean;

import com.google.gwt.event.shared.GwtEvent;



public class PickedItemEvent  extends GwtEvent<PickedItemEventHandler> {
	public static Type<PickedItemEventHandler> TYPE = new Type<PickedItemEventHandler>();
	
	private ItemBean item;
	private String triggerChar;

	public PickedItemEvent(ItemBean item, String triggerChar) {
		this.item = item;
		this.triggerChar = triggerChar;
	}

	@Override
	public Type<PickedItemEventHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(PickedItemEventHandler handler) {
		handler.onSelectedItem(this);
	}
	
	public ItemBean getSelectedItem() {
		return item;
	}
	
	public String getTriggerChar() {
		return triggerChar;
	}
}
