package org.gcube.portlets.widgtes.wsthreddssync.server;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.gcube.portlets.widgtes.wsthreddssync.shared.TransferOnThreddsReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionUtil {
	
	private static Logger logger = LoggerFactory.getLogger(SessionUtil.class);
	
	public static final String FOLDER_SYNCRONIZE_WITH_THREDDS = "Folder_Syncronize_With_Thredds";
	
	/**
	 * Sets the folder publishing on thredds.
	 *
	 * @param session the session
	 * @param report the report
	 */
	public static void setTransferPublishingOnThredds(HttpSession session, TransferOnThreddsReport report){

			Map<String, TransferOnThreddsReport> map = getMapTransferPublishingOnThredds(session);

			if(map!=null)
				map.put(report.getTransferId(), report);
	}


	/**
	 * Gets the folder publishing on thredds.
	 *
	 * @param session the session
	 * @return the folder publishing on thredds
	 */
	public static Map<String, TransferOnThreddsReport> getMapTransferPublishingOnThredds(HttpSession session){

		Map<String, TransferOnThreddsReport> map = null;
		try{

			map = (Map<String,TransferOnThreddsReport>) session.getAttribute(FOLDER_SYNCRONIZE_WITH_THREDDS);

			if(map==null){
				logger.info("Creating new map to trace syncronize with thredds... ");
				map = new HashMap<String, TransferOnThreddsReport>();
				session.setAttribute(FOLDER_SYNCRONIZE_WITH_THREDDS, map);
			}

		}catch (Exception e) {
			logger.error("an error occurred instancing PropertySpecialFolderReader ",e);
		}

		return map;

	}


	/**
	 * Ge transfer publishing on thredds for id.
	 *
	 * @param session the session
	 * @param transferId the transfer id
	 * @return the transfer on thredds report
	 */
	public static TransferOnThreddsReport geTransferPublishingOnThreddsForId(HttpSession session, String transferId){

		Map<String, TransferOnThreddsReport> map = getMapTransferPublishingOnThredds(session);

		if(map!=null){
			return  map.get(transferId);
		}

		return null;

	}
	
	
	/**
	 * Prints the as sys out.
	 *
	 * @param txt the txt
	 */
	public static void printAsSysOut(String txt) {
		
		System.out.println(txt);
	}

}
