package org.gcube.portlets.user.gisviewer.client.layerspanel;

import org.gcube.portlets.user.gisviewer.client.Constants;
import org.gcube.portlets.user.gisviewer.client.GisViewer;
import org.gcube.portlets.user.gisviewer.client.commons.beans.LayerItem;
import org.gcube.portlets.user.gisviewer.client.resources.Images;

import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MenuEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.event.SliderEvent;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Slider;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;

public class LayerToolsPanel extends VerticalPanel {
	private static final String TOOLS_PADDING = "20px";

	private static final String OPACITY_SLIDER_WIDTH = "120px";
	private static final String CHECKBOX_CELL_WIDTH = "28px";
	private static final String OPENBUTTON_CELL_WIDTH = "20px";
	private static final int LAYER_TOOLS_PANEL_HEIGHT = 84;
	private static final ImageResource ICON_TRANSECT_TIP = GisViewer.resources.iconTransectTip();
	private static final ImageResource ICON_TRANSECT_TIP_DELETE = GisViewer.resources.iconTransectTipDelete();
	private static final ImageResource ICON_CQL_TIP = GisViewer.resources.iconCqlTip();
	private static final ImageResource ICON_CQL_TIP_DELETE = GisViewer.resources.iconCqlTipDelete();
	private static final ImageResource ICON_TRIANGLE_RIGHT = GisViewer.resources.iconTriangleRight();
	private static final ImageResource ICON_TRIANGLE_DOWN = GisViewer.resources.iconTriangleDown();
	private static final ImageResource ICON_CLOSE_LAYER = GisViewer.resources.iconCloseLayer();
	private static final ImageResource ICON_CLOSE_LAYER_OVER = GisViewer.resources.iconCloseLayerOver();

	private static final String[][] FORMATS = {
		{"AtomPub", "application/atom+xml"},
		{"GIF", "image/gif"},
		{"GeoRSS", "application/rss+xml"},
		{"JPEG", "image/jpeg"},
		{"KML (compressed)", "application/vnd.google-earth.kmz+xml"},
		{"KML (plain)", "application/vnd.google-earth.kml+xml"},
		{"PDF", "application/pdf"},
		{"PNG", "image/png"},
		{"SVG", "image/svg+xml"},
		{"Tiff", "image/tiff"},
	};
	private static final AbstractImagePrototype[] FORMAT_IMAGES = {
		Images.iconAtompub(),
		Images.iconGeorss(),
		Images.iconGif(),
		Images.iconJpeg(),
		Images.iconKml(),
		Images.iconKml(),
		Images.iconPdf(),
		Images.iconPng(),
		Images.iconSvg(),
		Images.iconTiff()
	};

	private LayerItem layerItem;
	private VerticalPanel tools;
	private Image imgOpenButton;
	private Image imgCloseLayerButton;
	private Image imgCqlTip;
	private Image imgTransectTip;
	private CheckBox checkBox;
	private Slider opacitySlider;
	boolean isToolsOpened = false;
	
	private String fieldTransect=null;
	private String tableTransect=null;
	private LayersPanelHandler layersPanelHandler;
	private HorizontalPanel cp;

	private boolean cqlTipInserted=false;
	private boolean transectTipInserted=false;


	
	public LayerToolsPanel(LayerItem layerItem, LayersPanelHandler layersPanelHandler) {
		// create the vertical panel that represents all the layer ui
		super();
		this.layerItem = layerItem;
		this.layersPanelHandler = layersPanelHandler;
		setTransectInfo();
		
		this.setTableWidth("100%");
		
		// layer info
		cp = new HorizontalPanel();
		cp.setWidth("100%");

		createCheckBox();
		Html text = createText();
		createOpenButton();
		createTipImages();
		createOpacitySlider();
		createTools();
		createCloseLayerButton();
		
		cp.add(new Html("&nbsp;"));
		cp.add(checkBox);
		cp.add(imgOpenButton);
		cp.add(text);
		cp.add(imgCloseLayerButton);

		cp.setCellWidth(checkBox, CHECKBOX_CELL_WIDTH);
		cp.setCellWidth(imgOpenButton, OPENBUTTON_CELL_WIDTH);
		cp.setCellWidth(text, "100%");
		cp.setStyleName("layersPanel1");

		this.add(cp);
	}

	private void createTools() {
		tools = new VerticalPanel();
		tools.setStyleAttribute("padding-left", TOOLS_PADDING);
		//tools.setStyleAttribute("background-color", "#E5E5E5");
		tools.setStyleName("layersPanel2");
		tools.setHeight(LAYER_TOOLS_PANEL_HEIGHT);

		// TOOLBAR TRANSECT, FILTER AND EXPORT
		ToolBar toolBar1 = new ToolBar();
		toolBar1.setStyleName("myToolbar"); // TODO define style
		toolBar1.add(new SizedLabel("General", 10));
		toolBar1.add(new SeparatorToolItem());

		if ((tableTransect!=null && fieldTransect!=null)) {
			// transect button
			Button btnTransect = new Button("", Images.iconTransect(), new SelectionListener<ButtonEvent>(){
				@Override
				public void componentSelected(ButtonEvent ce) {
					setTransectTip(true);
					layersPanelHandler.activateTransect(layerItem, tableTransect, fieldTransect);
				}
			});
			btnTransect.setToolTip("Generate a Transect function");
			//btnTransect.setEnabled((tableTransect!=null && fieldTransect!=null));
			toolBar1.add(btnTransect);
		}

		// filter button
		Button btnFilter = new Button("", Images.iconFilter(), new SelectionListener<ButtonEvent>(){
			@Override
			public void componentSelected(ButtonEvent ce) {
				int left = ce.getButton().getAbsoluteLeft();
				int top = ce.getButton().getAbsoluteTop();
				layersPanelHandler.showFilterQuery(layerItem, left, top);
			}
		});
		btnFilter.setToolTip("Set a CQL filter to the layer " + this.layerItem.getName() + " (or remove previous filter)");
		toolBar1.add(btnFilter);

		// layer export	    
		Button btnExportLayer = new Button("", Images.iconExport());
		btnExportLayer.setToolTip("Export layer view");
		Menu menuExportLayer = new Menu();
		menuExportLayer.setStyleName("gisViewerMenu");
		int i=0;
		for (final String[] exportItem : FORMATS) {			
			menuExportLayer.add(new MenuItem(exportItem[0], FORMAT_IMAGES[i++], new SelectionListener<MenuEvent>(){
				@Override
				public void componentSelected(MenuEvent ce) {
					layersPanelHandler.openBrowserLayerImage(layerItem, exportItem[1], true);
					// TODO manage isWms
				}
			}));
		}
		btnExportLayer.setMenu(menuExportLayer);	    
		toolBar1.add(btnExportLayer);

		// layer save
		if (layersPanelHandler.isSaveSupported()) {
			Button btnSaveLayer = new Button("", Images.iconSave());
			btnSaveLayer.setToolTip("Save layer view");
			Menu menuSaveLayer = new Menu();
			menuSaveLayer.setStyleName("gisViewerMenu");
			i=0;
			for (final String[] exportItem : FORMATS) {			
				menuSaveLayer.add(new MenuItem(exportItem[0], FORMAT_IMAGES[i++], new SelectionListener<MenuEvent>(){
					@Override
					public void componentSelected(MenuEvent ce) {
						layersPanelHandler.saveLayerImage(layerItem, exportItem[1], true);
						// TODO manage isWms
					}
				}));
			}
			btnSaveLayer.setMenu(menuSaveLayer);	    
			toolBar1.add(btnSaveLayer);
		}

		tools.add(toolBar1);
		//	    tools.add(generalToolBar);


		// OPACITY TOOLBAR
		ToolBar toolBar2 = new ToolBar();
		toolBar2.setStyleName("myToolbar"); // TODO define style
		toolBar2.add(new SizedLabel("Opacity", 10));
		toolBar2.add(new SeparatorToolItem());
		toolBar2.add(opacitySlider);

		tools.add(toolBar2);

		
		// LEGEND TOOLBAR
		if (layerItem.isHasLegend()) {
			HorizontalPanel toolbar3 = new HorizontalPanel();
			toolbar3.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
			toolbar3.setStyleName("myToolbar");
			Label label = new SizedLabel("Legend", 10);
			toolbar3.add(label);
			toolbar3.add(new SeparatorToolItem());
	
			//legend button
			final Button btnLegend = new Button("", Images.iconLegend(), new SelectionListener<ButtonEvent>(){
				@Override
				public void componentSelected(ButtonEvent ce) {
					int left = ce.getButton().getAbsoluteLeft();
					int top = ce.getButton().getAbsoluteTop();
					layersPanelHandler.showLegend(layerItem, left, top);
				}
			});
			btnLegend.setToolTip("Show Legend");
			toolbar3.add(btnLegend);

			//		legend list
			if (layerItem.getStyles().size()==1) {
				toolbar3.add(new SizedLabel(layerItem.getStyle(), 10, 18));
			} else {
				String defaultStyle = layerItem.getStyle();
				
				
				final Button btnStyle = new Button((defaultStyle.length()<11) ? defaultStyle : defaultStyle.substring(0, 11) + "...");
				btnStyle.setToolTip("Change the style");
				Menu menuStyle = new Menu();
				menuStyle.setStyleName("gisViewerMenu");
				
				for (final String style : layerItem.getStyles()) {
					menuStyle.add(new MenuItem(style, new SelectionListener<MenuEvent>(){
						@Override
						public void componentSelected(MenuEvent ce) {
							btnStyle.setText((style.length()<11) ? style : style.substring(0, 11) + "...");
							System.out.println("index: " + style);
							layerItem.setStyle(style);
							layersPanelHandler.changeLegend(layerItem, style);
						}
					}));
				}
				btnStyle.setMenu(menuStyle);
				
				toolbar3.add(btnStyle);
			}
		
			tools.add(toolbar3);
		}
	}


	private void createOpacitySlider() {
		opacitySlider = new Slider();
		opacitySlider.setMinValue(0);
		opacitySlider.setMaxValue(100);
		opacitySlider.setIncrement(5);		
		opacitySlider.setWidth(OPACITY_SLIDER_WIDTH);
		opacitySlider.addListener(Events.Change, new Listener<SliderEvent>() {
			public void handleEvent(SliderEvent be) {
				double newValue = (double)(be.getNewValue())/100;
				layerItem.setOpacity(newValue);
				layersPanelHandler.setOpacityLayer(layerItem, newValue);
			}			
		});
		
		boolean isBrightLayer = false;
		for (String s : Constants.brightLayers)
			if (s.equals(layerItem.getName()))
				isBrightLayer = true;
		
		double opacity = (isBrightLayer ? 1.0 : Constants.defaultOpacityLayers);
		opacitySlider.setValue((int)(opacity*100));
	}

	private Html createText() {
		Html newHtml = new Html("<div style='font-size:12px;'>"+layerItem.getTitle()+"</div>");
		// Html newHtml = new Html(" -"+layerItem.getName()+"- ");
		//newHtml.setStyleAttribute("width", "120px");
		newHtml.setStyleAttribute("overflow", "hidden");
		newHtml.addListener(Events.OnClick, new Listener<BaseEvent>(){
			@Override
			public void handleEvent(BaseEvent be) {
				toggleTools();
			}
		});
		return newHtml;
	}

	private void createCheckBox() {
		checkBox = new CheckBox();
		checkBox.addListener(Events.Change, new Listener<FieldEvent>() {
			public void handleEvent(FieldEvent fe) {
				layerItem.setVisible(checkBox.getValue());
				if (checkBox.getValue())
					layersPanelHandler.showLayer(layerItem);
				else
					layersPanelHandler.hideLayer(layerItem);
            }
        });
		checkBox.setValue(layerItem.isVisible());		
	}

	private void createOpenButton() {
		imgOpenButton = new Image(ICON_TRIANGLE_RIGHT);
		imgOpenButton.setStyleName("imgCursor");
		//imgOpenButton.setSize("16px", "16px");
		imgOpenButton.addClickHandler(new ClickHandler(){
			@Override
			public void onClick(ClickEvent event) {
				toggleTools();
			}
		});
	}

	private void createCloseLayerButton() {
		imgCloseLayerButton = new Image(ICON_CLOSE_LAYER);
		//imgOpenButton.setSize("16px", "16px");
		imgCloseLayerButton.addClickHandler(new ClickHandler(){
			@Override
			public void onClick(ClickEvent event) {
				layersPanelHandler.removeLayer(layerItem);
			}
		});
		imgCloseLayerButton.addMouseOverHandler(new MouseOverHandler(){
			@Override
			public void onMouseOver(MouseOverEvent event) {
				imgCloseLayerButton.setResource(ICON_CLOSE_LAYER_OVER);
			}
		});
		imgCloseLayerButton.addMouseOutHandler(new MouseOutHandler(){
			@Override
			public void onMouseOut(MouseOutEvent event) {
				imgCloseLayerButton.setResource(ICON_CLOSE_LAYER);
			}
		});
		imgCloseLayerButton.setTitle("Remove Layer");
		imgCloseLayerButton.setStyleName("imgCql");
	}

	private void createTipImages() {
		imgCqlTip = new Image(ICON_CQL_TIP);
		//imgOpenButton.setSize("16px", "16px");
		imgCqlTip.addClickHandler(new ClickHandler(){
			@Override
			public void onClick(ClickEvent event) {
				layersPanelHandler.removeFilterQuery(layerItem);
			}
		});
		imgCqlTip.addMouseOverHandler(new MouseOverHandler(){
			@Override
			public void onMouseOver(MouseOverEvent event) {
				imgCqlTip.setResource(ICON_CQL_TIP_DELETE);
			}
		});
		imgCqlTip.addMouseOutHandler(new MouseOutHandler(){
			@Override
			public void onMouseOut(MouseOutEvent event) {
				imgCqlTip.setResource(ICON_CQL_TIP);
			}
		});
		imgCqlTip.setTitle("Remove CQL Filter");
		imgCqlTip.setStyleName("imgCql");
		

		imgTransectTip = new Image(ICON_TRANSECT_TIP);
		//imgOpenButton.setSize("16px", "16px");
		imgTransectTip.addClickHandler(new ClickHandler(){
			@Override
			public void onClick(ClickEvent event) {
				imgTransectTip.setResource(ICON_TRANSECT_TIP);
				layersPanelHandler.deactivateTransect(layerItem);
			}
		});
		imgTransectTip.addMouseOverHandler(new MouseOverHandler(){
			@Override
			public void onMouseOver(MouseOverEvent event) {
				imgTransectTip.setResource(ICON_TRANSECT_TIP_DELETE);
			}
		});
		imgTransectTip.addMouseOutHandler(new MouseOutHandler(){
			@Override
			public void onMouseOut(MouseOutEvent event) {
				imgTransectTip.setResource(ICON_TRANSECT_TIP);
			}
		});
		imgTransectTip.setTitle("Remove Transect interaction");
		imgTransectTip.setStyleName("imgCql");
	}

	// open/close tools
	protected void toggleTools() {
		if (isToolsOpened)
			this.remove(tools);
		else
			this.add(tools);
		this.layout();
		isToolsOpened = !isToolsOpened;
		imgOpenButton.setResource((isToolsOpened ? ICON_TRIANGLE_DOWN : ICON_TRIANGLE_RIGHT));
	}
	
	// sets transect info of a layer into node
	private void setTransectInfo() {
		if (!layerItem.isHasLegend())
			return;

		// search for transect by stylename
		boolean foundDefaultStyle = false;
		for (int i = 0; (i < Constants.defaultStyleTransects.length && !foundDefaultStyle); i++) {
			String styleName = Constants.defaultStyleTransects[i][0];
			String fieldTransect = Constants.defaultStyleTransects[i][1];
			String tableTransect = Constants.defaultStyleTransects[i][2];
			if (layerItem.getStyle().contentEquals(styleName)) {
				this.fieldTransect = fieldTransect;
				this.tableTransect = tableTransect;
				foundDefaultStyle = true;
			}
		}

		// search for transect by datastore
		if (!foundDefaultStyle) {
			boolean foundDataStore = false;
			for (int i = 0; (i < Constants.dataStoresWithTransect.length && !foundDataStore); i++) {
				if (layerItem.getDataStore().equals(
						Constants.dataStoresWithTransect[i]))
					foundDataStore = true;
			}

			if (foundDataStore) {
				if (layerItem.containsProperty("maxspeciescountinacell")) {
					this.fieldTransect = "maxspeciescountinacell";
					this.tableTransect = layerItem.getName();
				} else if (layerItem.containsProperty("probability")) {
					this.fieldTransect = "probability";
					this.tableTransect = layerItem.getName();
				}
			}
		}
		// TODO: search for a float property 	// layerItem.getFirstFloatPropertyName()
	}
	
	private class SizedLabel extends Label {
		public SizedLabel(String text, int size) {
			super(text);
			this.setStyleAttribute("font-size", ""+size+"px");
		}
		public SizedLabel(String text, int size, int maxChar) {
			super(text);
			if (text.length()>maxChar)
				this.setText(text.substring(0, maxChar) + "...");
			this.setStyleAttribute("font-size", ""+size+"px");
		}
	}

	public LayerItem getLayerItem() {
		return layerItem;
	}
	
	public void setCqlTip(boolean show) {
		if (show) {
			if (!cqlTipInserted) {
				cp.insert(imgCqlTip, 3);
				cqlTipInserted = true;
			}
		} else
			if (cqlTipInserted) {
				cp.remove(imgCqlTip);
				cqlTipInserted = false;
			}
	}

	public void setTransectTip(boolean show) {
		if (show) {
			if (!transectTipInserted) {
				cp.insert(imgTransectTip, (cqlTipInserted ? 4 : 3));
				transectTipInserted = true;
			}
		} else
			if (transectTipInserted) {
				cp.remove(imgTransectTip);
				transectTipInserted = false;
			}
	}
	
}
