package org.gcube.portlets.user.gisviewer.client.openlayers;


import org.gcube.portlets.user.gisviewer.client.commons.beans.LayerItem;
import org.gcube.portlets.user.gisviewer.client.resources.Images;

import com.extjs.gxt.ui.client.Style.ButtonScale;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.MenuEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ToggleButton;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.extjs.gxt.ui.client.widget.menu.SeparatorMenuItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;


public class ToolBarPanel extends ToolBar {

	private OpenLayersMap om;
	
	private HorizontalPanel transectPanel = new HorizontalPanel();
	private Label labelTransect = new Label("Draw a line for a transect on the layer ");

	private ToolbarHandler toolBarHandler;
	private LayerItem layerItemTransect;

	private Button maxExtentButton = new Button();
	private ToggleButton panToggle = new ToggleButton();
	private ToggleButton zoomInToggle = new ToggleButton();
	private Button zoomOutButton = new Button();
	private ToggleButton clickDataToggle = new ToggleButton();
	private ToggleButton boxDataToggle = new ToggleButton();
	private Button removeDataButton = new Button();
	private Button saveButton;

	private final static String TOGGLE_GROUP = "toggleGroup";

	private static final String BOX_DATA_TOOLTIP = "Data box selection";
	private static final String CLICK_DATA_TOOLTIP = "Data point selection";
	private static final String PAN_TOOLTIP = "Pan";
	private static final String ZOOM_IN_TOOLTIP = "Zoom in";
	private static final String ZOOM_OUT_TOOLTIP = "Zoom out";
	private static final String MAX_EXTENT_TOOLTIP = "Zoom to max extent";
	private static final String REMOVE_DATA_TOOLTIP = "Remove spatial query selection";
	private static final String SAVE_TOOLTIP = "Save a map snapshot";

	private enum TOGGLES {PAN, ZOOMIN, CLICKDATA, BOXDATA};
	private TOGGLES activeToggle = TOGGLES.PAN;

	private static final String[][] FORMATS = {
		{"GIF", "image/gif"},
		{"JPEG", "image/jpeg"},
		{"PNG", "image/png"},
	};
	private static final AbstractImagePrototype[] FORMAT_IMAGES = {
		Images.iconGif(),
		Images.iconJpeg(),
		Images.iconPng(),
	};


	public ToolBarPanel(ToolbarHandler toolbarHandler, OpenLayersMap om) {
		super();		
		this.om = om;
		this.toolBarHandler = toolbarHandler;

		setmaxExtentButton();
		setPanToggle();
		setZoomInToggle();
		setZoomOutButton();
		setClickDataToggle();
		setBoxDataToggle();
		setRemoveDataButton();
		setOpenBox();

		this.getAriaSupport().setLabel("Openlayers Toolbar");
		this.add(maxExtentButton);
		this.add(panToggle);
		this.add(zoomInToggle);
		//this.add(zoomOutButton);
		this.add(clickDataToggle);
		this.add(boxDataToggle);
		this.add(removeDataButton);		
		this.add(new SeparatorMenuItem());

		addProjectionBox();
		addTransectBox();
		this.add(saveButton);
	}



	/**
	 * 
	 */
	private void setOpenBox() {
		// layer export	    
		saveButton = new Button("", Images.iconSave());
		saveButton.setToolTip(SAVE_TOOLTIP);
		Menu menuSave = new Menu();
		menuSave.setStyleName("gisViewerMenu");
		int i=0;
		for (final String[] saveItem : FORMATS) {			
			menuSave.add(new MenuItem(saveItem[0], FORMAT_IMAGES[i++], new SelectionListener<MenuEvent>(){
				@Override
				public void componentSelected(MenuEvent ce) {
					toolBarHandler.openBrowserMapImage(saveItem[1], true);
				}
			}));
		}
		saveButton.setMenu(menuSave);	    
	}



	/**
	 * 
	 */
	private void addTransectBox() {
		labelTransect.setStyleName("vertical_middle");
		
		transectPanel.setBorders(true);
		transectPanel.add(labelTransect);
		
		transectPanel.setStyleName("geo-panel-body");
		add(new Html("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"));
		
		transectPanel.setVisible(false);
		
		add(transectPanel);
	}



	/**
	 * @param button
	 * @param boxDataTooltip 
	 * @param abstractImagePrototype 
	 */
	private void setUpBotton(Button button, AbstractImagePrototype img, String toolTip) {		
		button.setIcon(img);
		button.addStyleName("iconOpenlayersToolbar");
		button.setToolTip(toolTip);
		button.setSize(25, 25);
	}


	private void setBoxDataToggle() {
		setUpBotton(boxDataToggle, Images.iconBoxData(), BOX_DATA_TOOLTIP);
		boxDataToggle.setToggleGroup(TOGGLE_GROUP);
		boxDataToggle.addSelectionListener(new SelectionListener<ButtonEvent>() {
			@Override
			public void componentSelected(ButtonEvent be) {
				boolean isPressed = ((ToggleButton)be.getButton()).isPressed();
				togglePressed(isPressed, TOGGLES.BOXDATA);
				System.out.println("BOX "+isPressed);
			}
		});
	}


	private void setZoomInToggle() {
		setUpBotton(zoomInToggle, Images.iconZoomIn(), ZOOM_IN_TOOLTIP);
		zoomInToggle.setToggleGroup(TOGGLE_GROUP);
		zoomInToggle.addSelectionListener(new SelectionListener<ButtonEvent>() {
			@Override
			public void componentSelected(ButtonEvent be) {
				boolean isPressed = ((ToggleButton)be.getButton()).isPressed();
				togglePressed(isPressed, TOGGLES.ZOOMIN);
				System.out.println("ZOOM "+isPressed);
			}
		});
	}

	private void setClickDataToggle() {
		setUpBotton(clickDataToggle, Images.iconClickData(), CLICK_DATA_TOOLTIP);
		clickDataToggle.setToggleGroup(TOGGLE_GROUP);
		clickDataToggle.addSelectionListener(new SelectionListener<ButtonEvent>() {
			@Override
			public void componentSelected(ButtonEvent be) {
				boolean isPressed = ((ToggleButton)be.getButton()).isPressed();
				togglePressed(isPressed, TOGGLES.CLICKDATA);
				System.out.println("CLICK "+isPressed);
			}
		});
	}

	private void setPanToggle() {
		setUpBotton(panToggle, Images.iconPan(), PAN_TOOLTIP);
		panToggle.toggle(true);
		panToggle.setToggleGroup(TOGGLE_GROUP);
		panToggle.addSelectionListener(new SelectionListener<ButtonEvent>() {
			@Override
			public void componentSelected(ButtonEvent be) {
				boolean isPressed = ((ToggleButton)be.getButton()).isPressed();
				togglePressed(isPressed, TOGGLES.PAN);
			}
		});
	}

	private void setZoomOutButton() {
		setUpBotton(zoomOutButton, Images.iconZoomOut(), ZOOM_OUT_TOOLTIP);
		zoomOutButton.addSelectionListener(new SelectionListener<ButtonEvent>() {
			@Override
			public void componentSelected(ButtonEvent ce) {
				om.zoomOut();				
			}
		});
	}

	private void setmaxExtentButton() {
		setUpBotton(maxExtentButton, Images.iconMaxExtent(), MAX_EXTENT_TOOLTIP);
		maxExtentButton.addSelectionListener(new SelectionListener<ButtonEvent>() {
			@Override
			public void componentSelected(ButtonEvent ce) {
				om.zoomToMaxExtent();
			}
		});
	}

	/**
	 * 
	 */
	private void setRemoveDataButton() {
		setUpBotton(removeDataButton, Images.iconRemove(), REMOVE_DATA_TOOLTIP);
		removeDataButton.addSelectionListener(new SelectionListener<ButtonEvent>() {
			@Override
			public void componentSelected(ButtonEvent ce) {
				om.removeDataFeature();
			}
		});
	}

	private void togglePressed(boolean isPressed, TOGGLES toggleType) {
		if (!isPressed) {
			panToggle.toggle(true);
		}
		else {
			om.activateClickData(toggleType==TOGGLES.CLICKDATA);
			om.activateDrawBoxControl(toggleType==TOGGLES.BOXDATA);
			om.activateZoomIn(toggleType==TOGGLES.ZOOMIN);
			om.activatePan(toggleType==TOGGLES.PAN);
			toolBarHandler.deactivateTransect(layerItemTransect);
			
//			switch(toggleType) {
//			case BOXDATA:
//				break;
//			case CLICKDATA:
//				om.activateClickData();
//				om.deactivateDrawBoxControl();
//				om.deactivateZoomIn();
//				om.deactivatePan();
//				toolBarHandler.deactivateTransect(layerItemTransect);
//				break;
//			case PAN:
//				break;
//			case ZOOMIN:
//				break;
//			}
		}
	}

	/**
	 * @param layerItem
	 * @param b
	 */
	public void setTransectPanelVisible(LayerItem layerItem, boolean visible) {
		if (visible)
			this.labelTransect.setText("Draw a transect line for the layer "+layerItem.getName());
		else
			om.activateTransectDraw(false);
		this.transectPanel.setVisible(visible);
		this.layerItemTransect = layerItem;
	}


	/**
	 * 
	 */
	public void setAllUp() {
		om.activateClickData(false);
		om.activateDrawBoxControl(false);
		om.activateZoomIn(false);
		om.activatePan(false);
	}
	
	private void addProjectionBox(){
		// TODO
	}
}