package org.gcube.portlets.user.gisviewer.client.openlayers;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import org.gcube.portlets.user.gisviewer.client.Constants;
import org.gcube.portlets.user.gisviewer.client.commons.beans.LayerItem;
import org.gcube.portlets.user.gisviewer.client.commons.utils.ODLListBox;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.ToggleButton;


public class ToolBarPanelOld extends HorizontalPanel {
	
	private OpenLayersMap om;
	private HorizontalPanel transectPanel = new HorizontalPanel();
	private Label labelTransect = new Label("Draw a line for a transect on the layer ");
	
//	private ToggleButton zoomPlus = new ToggleButton();
//	private ToggleButton zoomMeno = new ToggleButton();
//	private ToggleButton panHand = new ToggleButton();
//	private ToggleButton clickData = new ToggleButton();
//	private ToggleButton editing = new ToggleButton();
	
	private ArrayList<ToggleButton> buttons = new ArrayList<ToggleButton>();
	
	
	private ToolbarHandler toolBarHandler;
	private LayerItem layerItemTransect;
	

	public ToolBarPanelOld(ToolbarHandler toolbarHandler, OpenLayersMap om) {
		super();
		this.om = om;
		this.toolBarHandler = toolbarHandler;
		
		buttons.add(new ToggleButton());
		buttons.add(new ToggleButton());
		buttons.add(new ToggleButton());
		buttons.add(new ToggleButton());
		buttons.add(new ToggleButton());
		//buttons.add(new ToggleButton());

		init();
		addOpenBox();

		//panHand
		buttons.get(0).setDown(true);
	}
	
	
	private void init() {
//		Button button = new Button("", new SelectionListener<ButtonEvent>() {
//			@Override
//			public void componentSelected(ButtonEvent ce) {
//				om.zoomToMaxExtent();
//			}
//		});
		Button button = new Button("", new ClickHandler() {
			
			public void onClick(ClickEvent arg0) {
				//map.zoomTo(1);
				om.zoomToMaxExtent();
			}
		});
		
		addButton(button, "Zoom to max extent", "bt_max_extent");
		
		//panHand
		buttons.get(0).addStyleName("bt_pan");
		buttons.get(0).addClickHandler(new ClickHandler() {
			
			public void onClick(ClickEvent arg0) {
				for (ToggleButton bt: buttons) {
					bt.setDown(false);
				}
				buttons.get(0).setDown(true);
				
				om.activatePan(true);
				om.activateZoomIn(false);
				om.activateClickData(false);
				om.deactivateDrawBoxControl();
				toolBarHandler.deactivateTransect(layerItemTransect);
			}
		});

		//zoomPlus
		buttons.get(1).addStyleName("bt_zoom_in");
		buttons.get(1).addClickHandler(new ClickHandler() {
			
			public void onClick(ClickEvent arg0) {
				for (ToggleButton bt: buttons) {
					bt.setDown(false);
				}
				buttons.get(1).setDown(true);
				om.activateZoomIn(true);
				om.activatePan(false);
				om.activateClickData(false);
				om.deactivateDrawBoxControl();
				toolBarHandler.deactivateTransect(layerItemTransect);
			}
		});
		
		//zoomMeno
		buttons.get(2).addStyleName("bt_zoom_out");
		buttons.get(2).setVisible(false);
		buttons.get(2).addClickHandler(new ClickHandler() {
			
			public void onClick(ClickEvent arg0) {
				for (ToggleButton bt: buttons) {
					bt.setDown(false);
				}
				buttons.get(2).setDown(true);
			}
		});
		
		//clickData
		buttons.get(3).addStyleName("bt_clickData");
		buttons.get(3).addClickHandler(new ClickHandler() {
			
			public void onClick(ClickEvent arg0) {
				for (ToggleButton bt: buttons) {
					bt.setDown(false);
				}
				buttons.get(3).setDown(true);
				om.activateClickData(true);
				om.activateDrawBoxControl(false);
				om.activateZoomIn(false);
				om.activatePan(false);
				toolBarHandler.deactivateTransect(layerItemTransect);
			}
		});

		//clickData
		buttons.get(4).addStyleName("bt_boxData");
		buttons.get(4).addClickHandler(new ClickHandler() {
			
			public void onClick(ClickEvent arg0) {
				for (ToggleButton bt: buttons) {
					bt.setDown(false);
				}
				buttons.get(4).setDown(true);
				om.activateDrawBoxControl(true);
				om.activateClickData(false);
				om.activateZoomIn(false);
				om.activatePan(false);
				toolBarHandler.deactivateTransect(layerItemTransect);
			}
		});
		//editing
//		buttons.get(4).addStyleName("bt_clickData");
//		buttons.get(4).addClickHandler(new ClickHandler() {
//			
//			public void onClick(ClickEvent arg0) {
//				for (ToggleButton bt: buttons) {
//					bt.setDown(false);
//				}
//				buttons.get(4).setDown(true);
//				om.activateDraw();
//				om.deactivateZoomIn();
//				om.deactivatePan();
//				om.deactivateClickData();
//			}
//		});
//		buttons.get(4).setVisible(false);
		
		HorizontalPanel hp_ToggleButton = new HorizontalPanel();
		
		for (ToggleButton bt: buttons) {
			hp_ToggleButton.add(bt);
		}
		
		add(hp_ToggleButton);
		
		//addTextBox("zoom:", ""+om.getMap().getZoom(),"30px", "x_textbox vertical_middle");
		addProjectionBox();
		
		addTransectBox();
	}

	public void setTransectPanelVisible(LayerItem layerItem, boolean visible) {
		if (visible)
			this.labelTransect.setText("Draw a transect line for the layer "+layerItem.getName());
		else
			om.activateTransectDraw(false);
		this.transectPanel.setVisible(visible);
		this.layerItemTransect = layerItem;
	}


	private void addTransectBox() {
		
		labelTransect.setStyleName("vertical_middle");
		
		transectPanel.setBorderWidth(2);
		transectPanel.add(labelTransect);
		
		transectPanel.setStyleName("geo-panel-body");
		add(new HTML("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"));
		
		transectPanel.setVisible(false);
		
		add(transectPanel);
	}

	public void setAllUp(){
		for (ToggleButton bt: buttons) {
			bt.setDown(false);
		}
	}
	
	public boolean isClickData() {
		return buttons.get(3).isDown();
	}
	
	public boolean isClickBox() {
		return buttons.get(4).isDown();
	}
	
	private void addProjectionBox(){
		
		final ListBox ls = new ListBox();
		ls.addItem(om.getProjection());
		ls.addItem("EPSG:3031");
		
		ls.addChangeHandler(new ChangeHandler() {
			
			public void onChange(ChangeEvent arg0) {
				om.reproject(ls.getValue(ls.getSelectedIndex()));
				
			}
		});
		
		//TextBox tb = new TextBox();
		//tb.setText(text);
		ls.setWidth("100px");
		ls.setStyleName("x_textbox vertical_middle");
		HorizontalPanel hp = new HorizontalPanel(); 
		hp.add(new HTML("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;projection:&nbsp;&nbsp;"));
		hp.add(ls);
		add(hp);
	}
	
//	private void addSaveBox(final String groupName){
//		
//		HorizontalPanel save_hp = new HorizontalPanel();
//		final Map<String, String> items = new HashMap<String, String>();
//		final ODLListBox save_list = new ODLListBox();
//		
//		
//		save_list.addItem("Select one", "");
//		
//		items.put("AtomPub", "application/atom+xml");
//		items.put("GIF", "image/gif");
//		items.put("GeoRSS", "application/rss+xml");
//		items.put("JPEG", "image/jpeg");
//		items.put("KML (compressed)", "application/vnd.google-earth.kmz+xml");
//		items.put("KML (plain)", "application/vnd.google-earth.kml+xml");
//		items.put("PDF", "application/pdf");
//		items.put("PNG", "image/png");
//		items.put("SVG", "image/svg+xml");
//		items.put("Tiff", "image/tiff");
//		items.put("Layout", "layout");
//		
//		save_list.setWidth("210px");
//		save_list.addOptionsGroup("WMS", items);
//		
//		save_hp.add(new HTML("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;save as&nbsp;&nbsp;"));
//		save_hp.add(save_list);
//		
////		Button btSave = new Button("", new SelectionListener<ButtonEvent>() {
////			@Override
////			public void componentSelected(ButtonEvent ce) {
////				if (!save_list.getValue(save_list.getSelectedIndex()).contentEquals("")) {					
////					if (items.containsKey(save_list.getItemText(save_list.getSelectedIndex()))) {						
////						
////						GroupInfo groupInfo = new GroupInfo();
////						groupInfo.setName(groupName + "_save");
////						ArrayList<LayerItem> layers = new ArrayList<LayerItem>();
////						
////						System.out.println(om.getExtent().getLowerLeftX());
////						System.out.println(om.getExtent().getLowerLeftY());
////						System.out.println(om.getExtent().getUpperRightX());
////						System.out.println(om.getExtent().getUpperRightY());
////						
////						for(LayerItem ls: om.getLayers()) {
////							
////							if (om.getLayer(ls.getLayer()).isVisible()) {
////								LayerItem e = ls.clone();								
////								//System.out.println(om.getLayer(ls.getLayer()).getJSObject());								
////								e.setStyle(om.getLayer(ls.getLayer()).getJSObject().getProperty("params").getPropertyAsString("STYLES"));								
////								//System.out.println(om.getLayer(ls.getLayer()).getJSObject().getProperty("params").getPropertyAsString("STYLES"));								
////								e.setOpacity(om.getLayer(ls.getLayer()).getOpacity());								
////								//System.out.println(om.getLayer(ls.getLayer()).getOpacity());								
////								layers.add(e);
////							}
////						}
////						
////						groupInfo.setLayers(layers);
////						BoundsMap bounds = new BoundsMap(om.getExtent().getLowerLeftX(), 
////														 om.getExtent().getLowerLeftY(), 
////														 om.getExtent().getUpperRightX(), 
////														 om.getExtent().getUpperRightY(), 
////														 om.getProjection());
////						groupInfo.setBounds(bounds);
////						
////						geoExtSaveHandler.saveGroup(
////								groupInfo,
////								save_list.getItemText(save_list.getSelectedIndex()), 
////								save_list.getValue(save_list.getSelectedIndex()));
////					}
////				}
////			}
////		});
//		Button btSave = new Button("", new ClickHandler() {			
//			public void onClick(ClickEvent arg0) {
//				if (!save_list.getValue(save_list.getSelectedIndex()).contentEquals("")) {					
//					if (items.containsKey(save_list.getItemText(save_list.getSelectedIndex()))) {						
//						
//						GroupInfo groupInfo = new GroupInfo();
//						groupInfo.setName(groupName + "_save");
//						ArrayList<LayerItem> layers = new ArrayList<LayerItem>();
//						
//						System.out.println(om.getExtent().getLowerLeftX());
//						System.out.println(om.getExtent().getLowerLeftY());
//						System.out.println(om.getExtent().getUpperRightX());
//						System.out.println(om.getExtent().getUpperRightY());
//						
//						for(LayerItem ls: om.getLayers()) {
//							
//							if (om.getLayer(ls.getLayer()).isVisible()) {
//								LayerItem e = ls.clone();								
//								//System.out.println(om.getLayer(ls.getLayer()).getJSObject());								
//								e.setStyle(om.getLayer(ls.getLayer()).getJSObject().getProperty("params").getPropertyAsString("STYLES"));								
//								//System.out.println(om.getLayer(ls.getLayer()).getJSObject().getProperty("params").getPropertyAsString("STYLES"));								
//								e.setOpacity(om.getLayer(ls.getLayer()).getOpacity());								
//								//System.out.println(om.getLayer(ls.getLayer()).getOpacity());								
//								layers.add(e);
//							}
//						}
//						
//						groupInfo.setLayers(layers);
//						BoundsMap bounds = new BoundsMap(om.getExtent().getLowerLeftX(), 
//														 om.getExtent().getLowerLeftY(), 
//														 om.getExtent().getUpperRightX(), 
//														 om.getExtent().getUpperRightY(), 
//														 om.getProjection());
//						groupInfo.setBounds(bounds);
//						
//						geoExtSaveHandler.saveGroup(
//								groupInfo,
//								save_list.getItemText(save_list.getSelectedIndex()), 
//								save_list.getValue(save_list.getSelectedIndex()));
//					}
//				}
//			}
//		});
//		
//		//addButton(btSave, "Save Data", "bt_save ");
//		save_hp.add(btSave);
//		
//		//TextBox tb = new TextBox();
//		//tb.setText(text);
//		save_list.setWidth("100px");
//		save_list.setStyleName("x_textbox vertical_middle");
//		
//		//save_hp.setWidth("100%");
//		//save_hp.setHorizontalAlignment(HasAlignment.ALIGN_RIGHT);
//		//add(save_hp);
//		
//		//setCellWidth(save_hp, "100%");
//		//setCellHorizontalAlignment(save_hp, HasAlignment.ALIGN_RIGHT);
//		
//	}
	
	private void addButton(Button button, String title, String style){
		button.setTitle(title);
		button.setStyleName(style);
		add(button);
	}


	private void addOpenBox() {
		HorizontalPanel openHp = new HorizontalPanel();
		final Map<String, String> items = new HashMap<String, String>();
		final ODLListBox formatCombobox = new ODLListBox();
		formatCombobox.addItem("Select an output format", "");
		
		//items.put("AtomPub", "application/atom+xml");
		items.put("GIF", "image/gif");
		//items.put("GeoRSS", "application/rss+xml");
		items.put("JPEG", "image/jpeg");
		//items.put("KML (compressed)", "application/vnd.google-earth.kmz+xml");
		//items.put("KML (plain)", "application/vnd.google-earth.kml+xml");
		//items.put("PDF", "application/pdf");
		items.put("PNG", "image/png");
		//items.put("SVG", "image/svg+xml");
		//items.put("Tiff", "image/tiff");
		//items.put("Layout", "layout");
		
		formatCombobox.setWidth("210px");
		formatCombobox.addOptionsGroup("WMS", items);
		
		final Button openMapImageButton = new Button("");
		final Button saveMapImageButton = new Button("");
		//final Button openButton = new Button("", IconHelper.create(Constants.snapshotIcon, 20, 20));
		
		formatCombobox.addChangeHandler(new ChangeHandler(){
			@Override
			public void onChange(ChangeEvent event) {
				int index = formatCombobox.getSelectedIndex();
				String value = formatCombobox.getValue(index);
				openMapImageButton.setEnabled(!value.contentEquals(""));
				openMapImageButton.setStyleName(value.contentEquals("") ? "bt_exportSnapshotDisabled" : "bt_exportSnapshot");				
				saveMapImageButton.setEnabled(!value.contentEquals(""));
				saveMapImageButton.setStyleName(value.contentEquals("") ? "bt_saveSnapshotDisabled" : "bt_saveSnapshot");				
			}
		});
		
		openHp.add(new HTML("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Export snapshot:&nbsp;"));
		openHp.add(formatCombobox);
		
//		openButton.addListener(Events.OnClick, new Listener<ButtonEvent>(){
//			@Override
//			public void handleEvent(ButtonEvent be) {
//			}			
//		});
		openMapImageButton.addClickHandler(new ClickHandler() {			
			public void onClick(ClickEvent arg0) {
				int index = formatCombobox.getSelectedIndex();
				String value = formatCombobox.getValue(index);
				String text = formatCombobox.getItemText(index);
				if (!value.contentEquals("") && items.containsKey(text))
					toolBarHandler.openBrowserMapImage(value, true);
				else
					Window.alert("Select an output format first.");
			}
		});
		openMapImageButton.setEnabled(false);
		openMapImageButton.setStyleName("bt_exportSnapshotDisabled");
		openMapImageButton.setTitle("Export snapshot.");
		openHp.add(openMapImageButton);
		
		if (Constants.buttonSaveLayerEnabled && toolBarHandler.isSaveSupported()) {
			saveMapImageButton.addClickHandler(new ClickHandler() {			
				public void onClick(ClickEvent arg0) {
					int index = formatCombobox.getSelectedIndex();
					String value = formatCombobox.getValue(index);
					String text = formatCombobox.getItemText(index);
					if (!value.contentEquals("") && items.containsKey(text))
						toolBarHandler.saveMapImage(value, true);
					else
						Window.alert("Select an output format first.");
				}
			});
			saveMapImageButton.setEnabled(false);
			saveMapImageButton.setStyleName("bt_saveSnapshotDisabled");
			saveMapImageButton.setTitle("Save snapshot.");
			openHp.add(saveMapImageButton);
		}

		//TextBox tb = new TextBox();
		//tb.setText(text);
		formatCombobox.setWidth("100px");
		formatCombobox.setStyleName("x_textbox vertical_middle");
		
		//save_hp.setWidth("100%");
		//save_hp.setHorizontalAlignment(HasAlignment.ALIGN_RIGHT);
		add(openHp);
		
		//setCellWidth(save_hp, "100%");
		//setCellHorizontalAlignment(save_hp, HasAlignment.ALIGN_RIGHT);
	}
}
