/**
 * 
 */
package org.gcube.portlets.user.gisviewer.server;

import java.util.List;

import org.gcube.common.geoserverinterface.GeoCallerConfigurationInterface;
import org.gcube.portlets.user.gisviewer.client.commons.beans.LayerItem;
import org.gcube.portlets.user.gisviewer.client.commons.beans.LayerItemsResult;
import org.gcube.portlets.user.gisviewer.client.commons.beans.WfsTable;

/**
 * @author "Federico De Faveri defaveri@isti.cnr.it"
 *
 */
public class DefaultGisViewerServiceImpl extends GisViewerServiceImpl {

	private static final long serialVersionUID = 7965911406156513171L;

	//DEVELOPMENT ENVIRONMENT
//	public static String geoServerUrl="http://geoserver-dev.d4science-ii.research-infrastructures.eu/geoserver";
//	public static String geonetworkUrl = "http://geoserver-dev.d4science-ii.research-infrastructures.eu:8080/geonetwork";

	//PRODUCTION ENVIRONMENT
	
	public static String geoServerUrl = "http://geoserver.d4science-ii.research-infrastructures.eu/geoserver";
	public static String geoNetworkUrl = "http://geoserver.d4science-ii.research-infrastructures.eu/geonetwork";
	
//	public static String geoServerWMSUrl = "http://geoserver.d4science-ii.research-infrastructures.eu/geoserver/wms";
//	public static String geoServerGWCUrl = "http://geoserver.d4science-ii.research-infrastructures.eu/geoserver/gwc/service/wms";
//	public static String urlGroup = "http://geoserver.d4science-ii.research-infrastructures.eu/geoserver/rest/layergroups.xml";
	/*
http://monitor.d4science.research-infrastructures.eu/chartview/?
x1=-58.88671875
&y1=30.5859375
&x2=-24.78515625
&y2=13.359375
&SRID=4326
&maxelements=1000
&minimumgap=-1
&tablename=lcod20120404193526226
&biodiversityfield=maxspeciescountinacell

http://monitor.d4science.research-infrastructures.eu/chartview/?
x1=-136.23046875
&y1=6.328125
&x2=-118.30078125
&y2=-13.359375
&SRID=4326
&maxelements=1000
&minimumgap=-1
&tablename=depth
&biodiversityfield=DepthMean
	*/
	private static final String geoNetworkUser = "admin";
	private static final String geoNetworkPwd = "admin";
	private static final String geoServerUser = GeoCallerConfigurationInterface.GEOSERVEGLOBALUSERNAME;
	private static final String geoServerPwd = GeoCallerConfigurationInterface.GEOSERVERGLOBALPASSWORD;
	private static final String transectUrl = "http://monitor.d4science.research-infrastructures.eu/chartview/"; //ex: "http://portal.d4science.research-infrastructures.eu/chartview/";

	protected GisViewerServiceParameters parameters;


	@Override
	protected GisViewerServiceParameters getParameters() {
		if (parameters == null) parameters = new GisViewerServiceParameters(geoServerUrl, geoServerUser, geoServerPwd, geoNetworkUrl, geoNetworkUser, geoNetworkPwd, transectUrl);
		return parameters;
	}

}
