/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.model.reference.properties;

import java.net.URI;
import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.resourcemanagement.model.impl.properties.ValueSchemaImpl;
import org.gcube.resourcemanagement.model.reference.properties.GCubeProperty;
import org.gcube.resourcemanagement.model.reference.properties.utilities.PropertyValidator;
import org.gcube.resourcemanagement.model.reference.properties.utilities.ValidatedTypedProperty;
import org.gcube.resourcemanagement.model.reference.properties.utilities.Validation;

@JsonDeserialize(as=ValueSchemaImpl.class)
@TypeMetadata(name="ValueSchema", description="This type aims at exposing a value which can be automatically managed by any client with no knowledge of its format.", version="1.0.0")
@Change(version="1.0.0", description="First Version")
public interface ValueSchema
extends GCubeProperty,
ValidatedTypedProperty<URI, String> {
    public static final String NAME = "ValueSchema";

    @Override
    default public Validation validate() {
        return new SchemaValidator().validate(this);
    }

    @Override
    @ISProperty(description="The value which schema is available at the URI provided in the schema property.", mandatory=true, nullable=false)
    public String getValue();

    @Override
    public void setValue(String var1);

    @Override
    @ISProperty(description="An URI containing a schema used to validate/interpret the content of the value. It is only an informative field. The validation is in charge of the client.")
    public URI getSchema();

    @Override
    public void setSchema(URI var1);

    public static class SchemaValidator
    implements PropertyValidator<ValueSchema> {
        @Override
        public Validation validate(ValueSchema property) {
            return Validation.success("Accepted!");
        }
    }
}

