/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.model.reference.entities.facets;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.Changelog;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.resourcemanagement.model.impl.entities.facets.ContactFacetImpl;

@JsonDeserialize(as=ContactFacetImpl.class)
@TypeMetadata(name="ContactFacet", description="ContactFacet captures information on a point of contact for the resource, i.e., a person or a department serving as the coordinator or focal point  of information concerning the resource.", version="1.1.0")
@Changelog(value={@Change(version="1.1.0", description="Added id property and removed the mandatory constraint on the email property to provide more flexibility and comply with privacy regulations (e.g., GDPR)."), @Change(version="1.0.0", description="First Version")})
public interface ContactFacet
extends Facet {
    public static final String NAME = "ContactFacet";
    public static final String EMAIL_PROPERTY = "eMail";
    public static final String EMAIL_PATTERN = "^[a-z0-9._%+-]{1,128}@[a-z0-9.-]{1,128}$";

    @ISProperty(description="An identifier for the point of contact.", sensitive=true)
    public String getId();

    public void setId(String var1);

    @ISProperty(description="A name describing the profession or marital status of the point of contact. e.g., Dr, Mrs, Mr.")
    public String getTitle();

    public void setTitle(String var1);

    @ISProperty(description="First Name", mandatory=true, nullable=false)
    public String getName();

    public void setName(String var1);

    @ISProperty(description="Middle Name")
    public String getMiddleName();

    public void setMiddleName(String var1);

    @ISProperty(description="Surname", mandatory=true, nullable=false)
    public String getSurname();

    public void setSurname(String var1);

    @ISProperty(description="Email address", name="eMail", nullable=false, sensitive=true, regexpr="^[a-z0-9._%+-]{1,128}@[a-z0-9.-]{1,128}$")
    public String getEMail();

    public void setEMail(String var1);
}

