/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.entities.facets;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.properties.Event;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.Changelog;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;
import org.gcube.resourcemanagement.model.impl.entities.facets.EventFacetImpl;

/**
 * EventFacet captures information on a certain event/happening characterising the life cycle of the resource.
 * 
 * Examples of an event are the start time of a virtual machine or the activation time of an electronic service.
 *
 * https://wiki.gcube-system.org/gcube/GCube_Model#Event_Facet
 * 
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonDeserialize(as=EventFacetImpl.class)
@TypeMetadata(
	name = EventFacet.NAME, 
	description = "EventFacet captures information on a certain event/happening characterising the life cycle of the resource. "
			+ "Examples of an event are the start time of a virtual machine or the activation time of an electronic service.",
	version = EventFacet.VERSION
)
@Changelog ({
	@Change(version = EventFacet.VERSION, description = "Switching to {@link Event} Property added in the information-system-model"),
	@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
})
public interface EventFacet extends Facet {

	/** The name associated with this facet */
	public static final String NAME = "EventFacet"; // EventFacet.class.getSimpleName();
	/** The version associated with this facet */
	public static final String VERSION = "2.0.0";
	
	public static final String EVENT_PROPERTY = "event";
	
		/**
	 * Actually is not mandatory for backward compatibility.
	 * In the next version this method will be deprecated to and it will be replaced
	 * by a method with the following signature
	 * 
	 * public Event getEvent()
	 * 
	 * This is not actually possible because we need to maintain 
	 * {@link EventFacet#getEvent()} for backward compatibility 
	 * 
	 * @return the event
	 */
	@ISProperty(name=EVENT_PROPERTY, type=Object.class, description = "The event eventually described by the five W (What, When, Who, Where, Why)", mandatory=false, nullable=false)
	public Event getEvent();
	
	/**
	 * Set the event
	 * @param event the event to set
	 */
	public void setEvent(Event event);
	
}