/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.entities.facets;

import org.gcube.com.fasterxml.jackson.annotation.JsonGetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonSetter;
import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;
import org.gcube.resourcemanagement.model.impl.entities.facets.NetworkingFacetImpl;

/**
 * NetworkingFacet captures information on any (computer) network interface 
 * associated with the resource.
 * It is mainly used to describe the network interface of a host. 
 * It should not be confused with the {@link AccessPointFacet} 
 * which instead describes the protocol and the endpoint of a web-based service.
 * 
 * https://wiki.gcube-system.org/gcube/GCube_Model#Networking_Facet
 * 
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonDeserialize(as=NetworkingFacetImpl.class)
@TypeMetadata(
	name = NetworkingFacet.NAME, 
	description = "NetworkingFacet captures information on any (computer) network interface associated with the resource."
			+ "It is mainly used to describe the network interface of a host. "
			+ "It should not be confused with the {@link AccessPointFacet} "
			+ "which instead describes the protocol and the endpoint of a web-based service.",
	version = Version.MINIMAL_VERSION_STRING
)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface NetworkingFacet extends Facet {
	
	/** The name associated with this facet */
	public static final String NAME = "NetworkingFacet"; // NetworkingFacet.class.getSimpleName();
	
	/** The name of 'IPAddress' property */
	public static final String IP_ADDRESS = "IPAddress";
	public static final String IP_ADDRESS_REGEX = "^((25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])\\.(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])\\.(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])\\.(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])|(([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4}|([0-9A-Fa-f]{1,4}:){1,7}:|:(:[0-9A-Fa-f]{1,4}){1,7}|([0-9A-Fa-f]{1,4}:){1,6}:[0-9A-Fa-f]{1,4}|([0-9A-Fa-f]{1,4}:){1,5}(:[0-9A-Fa-f]{1,4}){1,2}|([0-9A-Fa-f]{1,4}:){1,4}(:[0-9A-Fa-f]{1,4}){1,3}|([0-9A-Fa-f]{1,4}:){1,3}(:[0-9A-Fa-f]{1,4}){1,4}|([0-9A-Fa-f]{1,4}:){1,2}(:[0-9A-Fa-f]{1,4}){1,5}|[0-9A-Fa-f]{1,4}:(:[0-9A-Fa-f]{1,4}){1,6}|:(:[0-9A-Fa-f]{1,4}){1,6}))$";
	
	/**
	 * Returns a default instance of NetworkingFacet
	 * @return a default instance of NetworkingFacet
	 */
	public static NetworkingFacet getDefaultInstance() {
		return new NetworkingFacetImpl();
	}
	
	/**
	 * The Host Name
	 * @return the host name
	 */
	@ISProperty(description = "Host Name")
	public String getHostName();
	
	/**
	 * Sets the Host Name
	 * @param hostName the host name
	 */
	public void setHostName(String hostName);
	
	/**
	 * The Domain Name
	 * @return the domain name
	 */
	@ISProperty(description = "Domain Name")
	public String getDomainName();
	
	/**
	 * Sets the Domain Name
	 * @param domainName the domain name
	 */
	public void setDomainName(String domainName);
	
	/**
	 * Internet Protocol (IP) Address
	 * @return the IP address
	 */
	@ISProperty(name=IP_ADDRESS, description = "Internet Protocol (IP) Address", mandatory=true, nullable=false, regexpr = IP_ADDRESS_REGEX)
	@JsonGetter(value = IP_ADDRESS)
	public String getIPAddress();
	
	/**
	 * Sets the Internet Protocol (IP) Address
	 * @param ipAddress the IP address
	 */
	@JsonSetter(value = IP_ADDRESS)
	public void setIPAddress(String ipAddress);
	
	/**
	 * Network Mask
	 * @return the network mask
	 */
	@ISProperty(description = "Network Mask")
	public String getMask();
	
	/**
	 * Sets the Network Mask
	 * @param mask the network mask
	 */
	public void setMask(String mask);
	
	/**
	 * Broadcast Address
	 * @return the broadcast address
	 */
	@ISProperty(description = "Broadcast Address")
	public String getBroadcastAddress();
	
	/**
	 * Sets the Broadcast Address
	 * @param broadcastAddress the broadcast address
	 */
	public void setBroadcastAddress(String broadcastAddress);
	
}