/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.entities.facets;

import java.util.List;

import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;
import org.gcube.resourcemanagement.model.impl.entities.facets.TemplateFacetImpl;
import org.gcube.resourcemanagement.model.reference.properties.AttributeProperty;
import org.gcube.resourcemanagement.model.reference.properties.utilities.Named;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonDeserialize(as=TemplateFacetImpl.class)
@TypeMetadata(
	name = TemplateFacet.NAME, 
	description = "This facet define a template for a Facet to instantiate using the list of attributes specified. The type of the instatianted facet is specified in 'targetFacetType' attribute",
	version = Version.MINIMAL_VERSION_STRING
)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface TemplateFacet extends Facet, Named {
	
	/** The name associated with this facet */
	public static final String NAME = "TemplateFacet"; // TemplateFacet.class.getSimpleName();

	/** The name of 'description' property */
	public static final String DESCRIPTION_PROPERTY = "description";
	/** The name of 'targetType' property */
	public static final String TARGET_TYPE_PROPERTY = "targetType";
	/** The name of 'properties' property */
	public static final String PROPERTIES_PROPERTY = "properties";
	
	/**
	 * Returns a default instance of TemplateFacet
	 * @return a default instance of TemplateFacet
	 */
	public static TemplateFacet getDefaultInstance() {
		return new TemplateFacetImpl();
	}

	/**
	 * The name of the template
	 * @return the name
	 */
	@Override
	@ISProperty(name = NAME_PROPERTY, description = "The name of the template", mandatory = true, nullable = false)
	public String getName();

	/**
	 * Sets the name of the template
	 * @param name the name
	 */
	@Override
	public void setName(String name);
	
	/**
	 * The description of the template
	 * @return the description
	 */
	@ISProperty(name = DESCRIPTION_PROPERTY, description = "The description of the template", readonly = false, mandatory = true, nullable = false)
	public String getDescription();
	
	/**
	 * Sets the description of the template
	 * @param description the description
	 */
	public void setDescription(String description);
	
	/**
	 * The type of Facet to instantiate with the attributes valued
	 * @return the targetType
	 */
	@ISProperty(name = TARGET_TYPE_PROPERTY, description = "The type of Facet to instantiate with the attributes valued", readonly = false, mandatory = true, nullable = false)
	public String getTargetType();
	
	/**
	 * Sets the type of Facet to instantiate with the attributes valued
	 * @param targetType the targetType
	 */
	public void setTargetType(String targetType);
	
	/**
	 * The attributes of the template to be created when instantiated
	 * @return the properties
	 */
	@ISProperty(name = PROPERTIES_PROPERTY, description = "The attributes of the template to be created when instantiated", readonly = false, mandatory = true, nullable = false, min=1)
	public List<AttributeProperty> getProperties();
	
	/**
	 * Sets the attributes of the template to be created when instantiated
	 * @param properties the properties
	 */
	public void setProperties(List<AttributeProperty> properties);
	
	/**
	 * Adds an attribute to the template to be created when instantiated
	 * @param property the property
	 */
	@JsonIgnore
	public void addProperty(AttributeProperty property);
	
}