/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.relations.consistsof;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;
import org.gcube.resourcemanagement.model.impl.relations.consistsof.HasDeveloperImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.ContactFacet;

/**
 * HasDeveloper indicates that the target {@link ContactFacet} contains the information related to a 
 * developer of the source resource e.g., the contact points of the developer of a software.
 * 
 * https://wiki.gcube-system.org/gcube/GCube_Model#HasDeveloper
 * 
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonDeserialize(as=HasDeveloperImpl.class)
@TypeMetadata(
	name = HasDeveloper.NAME, 
	description = "HasDeveloper indicates that the target {@link ContactFacet} contains the information related "
			+ "to a developer of the source resource e.g., the contact points ofthe developer of a software.",
	version = Version.MINIMAL_VERSION_STRING
)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface HasDeveloper<Out extends Resource, In extends ContactFacet> 
	extends HasContact<Out, In> {

	/** The name associated with this relation */
	public static final String NAME = "HasDeveloper"; // HasDeveloper.class.getSimpleName();

	/**
	 * Returns a default instance of HasDeveloper
	 * @return a default instance of HasDeveloper
	 */
	public static <Out extends Resource, In extends ContactFacet> HasDeveloper<Out, In> getDefaultInstance(Out out, In in) {
		return new HasDeveloperImpl<Out, In>(out, in);
	}

}
