package org.gcube.resourcemanagement.contexts.impl.properties;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import org.gcube.com.fasterxml.jackson.annotation.JsonFormat;
import org.gcube.informationsystem.base.reference.Element;

/**
 * Basic Information about a GCube Context
 * @author Luca Frosini (ISTI - CNR)
 */
public class BasicInformation {

	/**
	 * Description of the Context
	 */
	protected String description;
	/**
	 * Designers of the Context
	 */
	protected Set<String> designers;
	/**
	 * Managers of the Context
	 */
	protected Set<String> managers;
	/**
	 * Start date of the Context
	 */
	protected Date from;
	/**
	 * Can be null. It means no end date defined.
	 */
	protected Date to;
	
	/**
	 * Description of the Context
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}
	
	/**
	 * Description of the Context
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * Designers of the Context
	 * @return the designers
	 */
	public Set<String> getDesigners() {
		return designers;
	}
	
	/**
	 * Designers of the Context
	 * @param designers the designers to set
	 */
	public void setDesigners(Set<String> designers) {
		this.designers = designers;
	}
	
	/**
	 * Add a designer to the Context
	 * @param designer the designer to add
	 */
	public void addDesigner(String designer) {
		if(this.designers==null) {
			this.designers = new HashSet<>();
		}
		this.designers.add(designer);
	}
	
	/**
	 * Managers of the Context
	 * @return the managers
	 */
	public Set<String> getManagers() {
		return managers;
	}
	
	/**
	 * Managers of the Context
	 * @param managers the managers to set
	 */
	public void setManagers(Set<String> managers) {
		this.managers = managers;
	}
	
	/**
	 * Add a manager to the Context
	 * @param manager the manager to add
	 */
	public void addManager(String manager) {
		if(this.managers==null) {
			this.managers = new HashSet<>();
		}
		this.managers.add(manager);
	}
	
	/**
	 * Start date of the Context
	 * @return the start date
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = Element.DATETIME_PATTERN)
	public Date getFrom() {
		return from;
	}
	
	/**
	 * Start date of the Context
	 * @param from the start date to set
	 */
	public void setFrom(Date from) {
		this.from = from;
	}
	
	/**
	 * End date of the Context
	 * @return the end date
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = Element.DATETIME_PATTERN)
	public Date getTo() {
		return to;
	}
	
	/**
	 * End date of the Context
	 * @param to the end date to set
	 */
	public void setTo(Date to) {
		this.to = to;
	}
	
}
