package org.gcube.resourcemanagement.model.impl.relations.consistsof;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.resourcemanagement.model.reference.entities.facets.CoverageFacet;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.HasSpatialCoverage;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value = HasSpatialCoverage.NAME)
public class HasSpatialCoverageImpl<Out extends Resource, In extends CoverageFacet>
		extends HasCoverageImpl<Out, In> implements HasSpatialCoverage<Out, In> {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = -6379008183604723927L;

	/**
	 * Protected default constructor
	 */
	protected HasSpatialCoverageImpl() {
		super();
	}

	/**
	 * Creates an instance of HasSpatialCoverage
	 * @param source the source Resource
	 * @param target the target CoverageFacet
	 */
	public HasSpatialCoverageImpl(Out source, In target) {
		super(source, target);
	}
	
	/**
	 * Creates an instance of HasSpatialCoverage
	 * @param source the source Resource
	 * @param target the target CoverageFacet
	 * @param propagationConstraint the Propagation Constraint
	 */
	public HasSpatialCoverageImpl(Out source, In target,
			PropagationConstraint propagationConstraint) {
		super(source, target, propagationConstraint);
	}

}
