/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.entities.facets;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.utils.Version;
import org.gcube.resourcemanagement.model.impl.entities.facets.DescriptiveMetadataFacetImpl;
import org.gcube.resourcemanagement.model.reference.properties.ValueSchema;

/**
 * DescriptiveMetadataFacet captures information on descriptive metadata 
 * to be associated with the resource.
 * This facet is mainly used to attach metadata to a Dataset.
 * 
 * https://wiki.gcube-system.org/gcube/GCube_Model#Descriptive_Metadata_Facet
 * 
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonDeserialize(as=DescriptiveMetadataFacetImpl.class)
@TypeMetadata(
	name = DescriptiveMetadataFacet.NAME, 
	description = "DescriptiveMetadataFacet captures information on descriptive metadata to be associated with the resource. "
			+ "This facet is mainly used to attach metadata to a Dataset.",
	version = Version.MINIMAL_VERSION_STRING
)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
public interface DescriptiveMetadataFacet extends Facet {
	
	/** The name associated with this facet */
	public static final String NAME = "DescriptiveMetadataFacet"; // DescriptiveMetadataFacet.class.getSimpleName();

	/**
	 * Returns a default instance of DescriptiveMetadataFacet
	 * @return a default instance of DescriptiveMetadataFacet
	 */
	public static DescriptiveMetadataFacet getDefaultInstance() {
		return new DescriptiveMetadataFacetImpl();
	}

	/**
	 * A metadata record representing the descriptive metadata according to the schema
	 * @return the metadata
	 */
	@ISProperty(description = "A metadata record representing the descriptive metadata according to the schema", mandatory=true, nullable=false)
	public ValueSchema getDescriptiveMetadata();
	
	/**
	 * Sets a metadata record representing the descriptive metadata according to the schema
	 * @param metadata the metadata
	 */
	public void setDescriptiveMetadata(ValueSchema metadata);

}