/**
 * 
 */
package org.gcube.resourcemanagement.model.impl.entities.facets;

import java.io.Serial;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.informationsystem.model.impl.entities.FacetImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.LocationFacet;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=LocationFacet.NAME)
public class LocationFacetImpl extends FacetImpl implements LocationFacet {

	/**
	 * Generated Serial version UID
	 */
	@Serial
	private static final long serialVersionUID = 4041460426127480418L;
	

	/** 
	 * A human english name for the location, e.g., a city name, a country name, a site name, a region name, etc.
	 */
	protected String location;

	protected ObjectNode spatialGeometry;
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getLocation() {
		return location;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setLocation(String location) {
		this.location = location;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ObjectNode getSpatialGeometry() {
		return spatialGeometry;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setSpatialGeometry(ObjectNode spatialGeometry) {
		this.spatialGeometry = spatialGeometry;
	}
	
}
