/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.analyser;

import jakarta.ws.rs.WebApplicationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.queries.templates.reference.properties.QueryTemplateReference;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.resourcemanagement.analyser.InstanceAnalyser;
import org.gcube.resourcemanagement.model.reference.entities.facets.DiscoveryFacet;
import org.gcube.resourcemanagement.model.reference.entities.resources.GCubeResource;
import org.gcube.resourcemanagement.resource.DerivatedRelatedResourceGroup;
import org.gcube.resourcemanagement.resources.GCubeInstance;

public abstract class GCubeAnalyser<GR extends GCubeResource>
extends InstanceAnalyser<GR, GCubeInstance> {
    public GCubeAnalyser() {
    }

    public GCubeAnalyser(String type, UUID instanceUUID) {
        super(type, instanceUUID);
    }

    public Class<GCubeInstance> getInstanceClass() {
        return GCubeInstance.class;
    }

    protected Set<DerivatedRelatedResourceGroup<GCubeInstance>> getDerivatedRelatedResourceGroup() throws WebApplicationException, ResourceRegistryException {
        HashSet<DerivatedRelatedResourceGroup<GCubeInstance>> derivatedRelatedResourceGroups = new HashSet<DerivatedRelatedResourceGroup<GCubeInstance>>();
        List discoveryFacets = ((GCubeResource)this.resource).getFacets(DiscoveryFacet.class);
        for (DiscoveryFacet discoveryFacet : discoveryFacets) {
            DerivatedRelatedResourceGroup<GCubeInstance> derivatedRelatedResourceGroup = this.getDerivatedRelatedResourceGroup(discoveryFacet);
            derivatedRelatedResourceGroups.add(derivatedRelatedResourceGroup);
        }
        return derivatedRelatedResourceGroups;
    }

    protected DerivatedRelatedResourceGroup<GCubeInstance> getDerivatedRelatedResourceGroup(DiscoveryFacet discoveryFacet) throws WebApplicationException, ResourceRegistryException {
        this.logger.trace("Analyzing DiscoveryFacet: {}", (Object)discoveryFacet);
        DerivatedRelatedResourceGroup derivatedRelatedResourceGroup = new DerivatedRelatedResourceGroup(this.getInstanceClass());
        derivatedRelatedResourceGroup.setAncestor(this.getResource());
        derivatedRelatedResourceGroup.setName(discoveryFacet.getGroup());
        derivatedRelatedResourceGroup.setDescription(discoveryFacet.getDescription());
        derivatedRelatedResourceGroup.setMin(discoveryFacet.getMin());
        derivatedRelatedResourceGroup.setMax(discoveryFacet.getMax());
        List<Resource> derivatedRelatedResources = this.discoverDerivatedRelatedResources(discoveryFacet);
        derivatedRelatedResourceGroup.setRelatedResources(derivatedRelatedResources);
        return derivatedRelatedResourceGroup;
    }

    protected List<Resource> discoverDerivatedRelatedResources(DiscoveryFacet discoveryFacet) throws WebApplicationException, ResourceRegistryException {
        this.logger.debug("Discovering Derivated Related Resources (D-RRs) according DiscoveryFacet: {}", (Object)discoveryFacet);
        ArrayList<Resource> derivatedRelatedResources = new ArrayList<Resource>();
        ArrayNode queries = discoveryFacet.getQueries();
        for (JsonNode query : queries) {
            derivatedRelatedResources.addAll(this.executeQuery(query));
        }
        List queryTemplates = discoveryFacet.getQueryTemplates();
        for (QueryTemplateReference queryTemplate : queryTemplates) {
            derivatedRelatedResources.addAll(this.executeQueryTemplate(queryTemplate));
        }
        return derivatedRelatedResources;
    }
}

