package org.gcube.resourcemanagement.context;

import java.util.UUID;

import org.gcube.common.security.secrets.Secret;
import org.gcube.informationsystem.contexts.reference.entities.Context;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.resourcemanagement.utils.AuthorizationUtils;

import jakarta.ws.rs.InternalServerErrorException;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class RMTargetContext extends TargetContext {

    /**
     * Default constructor for RMTargetContext
     */
    public RMTargetContext(){
        super();
    }

    /**
     * Create RMTargetContext from a context UUID
     * @param uuid the UUID of the context
     * @throws ContextNotFoundException if the context is not found
     * @throws ResourceRegistryException if there's an error in the resource registry
     */
    public RMTargetContext(UUID uuid) throws ContextNotFoundException, ResourceRegistryException {
        super(uuid);
    }

    /**
     * Create RMTargetContext from a context full path
     * @param contextFullPath the full path of the context
     * @throws ContextNotFoundException if the context is not found
     * @throws ResourceRegistryException if there's an error in the resource registry
     */
    public RMTargetContext(String contextFullPath) throws ContextNotFoundException, ResourceRegistryException{
        super(contextFullPath);
    }

    /**
     * Create RMTargetContext from a Context object
     * @param context the Context object
     * @throws ResourceRegistryException if there's an error in the resource registry
     */
    public RMTargetContext(Context context) throws ResourceRegistryException {
        super(context);
    }

    @Override
    public Secret getSecret() {
        if(this.secret == null || this.secret.isExpired()){
            try {
                this.secret = AuthorizationUtils.getSecret(this.contextFullPath);
            } catch (Exception e) {
                throw new InternalServerErrorException("Unable to retrieve Application Token for context " + this.contextFullPath, e);
            }
        } 
        return this.secret;
    }

}
