/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.contexts;

import java.io.File;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.GCUBEScheduledHandler;
import org.gcube.common.vremanagement.deployer.impl.contexts.Configuration;
import org.gcube.common.vremanagement.deployer.impl.contexts.HDeployerCompleteGHNState;
import org.gcube.common.vremanagement.deployer.impl.contexts.StatefulPortTypeContext;
import org.gcube.common.vremanagement.deployer.impl.state.DeployerResource;
import org.globus.wsrf.ResourceException;

public class ServiceContext
extends GCUBEServiceContext {
    public static final String JNDI_NAME = "gcube/common/vremanagement/Deployer/service";
    static ServiceContext cache = new ServiceContext();
    DeployerResource resource = null;

    private ServiceContext() {
    }

    public static ServiceContext getContext() {
        return cache;
    }

    protected String getJNDIName() {
        return JNDI_NAME;
    }

    protected void onReady() throws Exception {
        File rdir;
        File pdir;
        File tmpdir;
        File srcdir;
        super.onReady();
        File basedir = new File(Configuration.BASEDIR);
        if (!basedir.exists()) {
            basedir.mkdir();
        }
        if (!(srcdir = new File(Configuration.BASESOURCEDIR)).exists()) {
            srcdir.mkdir();
        }
        if (!(tmpdir = new File(Configuration.BASEDEPLOYDIR)).exists()) {
            tmpdir.mkdir();
        }
        if (!(pdir = new File(Configuration.BASEPATCHDIR)).exists()) {
            pdir.mkdir();
        }
        if (!(rdir = new File(Configuration.REPORTDIR)).exists()) {
            rdir.mkdir();
        }
        HDeployerStateScheduler stateScheduler = new HDeployerStateScheduler(10L, GCUBEScheduledHandler.Mode.LAZY);
        stateScheduler.setScheduled(new HDeployerState());
        stateScheduler.run();
    }

    public String getConfigurationFileAbsolutePath(String relativepath) {
        File file = super.getFile(relativepath, new boolean[]{false});
        if (!file.exists() || file.isDirectory()) {
            file.mkdirs();
        }
        return file.getAbsolutePath();
    }

    protected class HDeployerCompleteGHNStateHandler
    extends GCUBEScheduledHandler {
        public HDeployerCompleteGHNStateHandler(long interval, GCUBEScheduledHandler.Mode mode) {
            super(interval, mode, new GCUBEHandler[0]);
        }

        protected boolean repeat(Exception exception, int exceptionCount) {
            if (exception != null) {
                this.logger.warn((Object)("Failed to complete the GHN profile (attempt " + exceptionCount + " out of 20)"), (Throwable)exception);
                if (exceptionCount >= 20) {
                    this.logger.error((Object)"Max attempts reached, no more chance to add the scopes to the previously deployed packages");
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    protected class HDeployerState
    extends GCUBEHandler<Object> {
        public void run() throws Exception {
            for (GCUBEScope scope : ServiceContext.getContext().getInstance().getScopes().values()) {
                this.logger.trace((Object)("Adding Deployer resource to " + scope));
                ServiceContext.getContext().setScope(scope);
                ServiceContext.this.resource = (DeployerResource)StatefulPortTypeContext.getContext().getWSHome().create(StatefulPortTypeContext.getContext().makeKey("DeployerState"), new Object[0]);
                ServiceContext.this.resource.store();
            }
            ServiceContext.this.getInstance().subscribeResourceEvents((GCUBEResource.ResourceConsumer)new DeployerResourceConsumer(), new GCUBEResource.ResourceTopic[]{GCUBEResource.ResourceTopic.ADDSCOPE});
            this.scheduleNextHandler();
        }

        private void scheduleNextHandler() {
            this.logger.info((Object)"Updating the Deployer resource...");
            HDeployerCompleteGHNStateHandler updateScheduler = new HDeployerCompleteGHNStateHandler(10L, GCUBEScheduledHandler.Mode.LAZY);
            HDeployerCompleteGHNState completeStatePlease = new HDeployerCompleteGHNState();
            completeStatePlease.setHandled((Object)ServiceContext.this.resource);
            updateScheduler.setScheduled(completeStatePlease);
            try {
                updateScheduler.run();
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to schedule the update of the scopes for the deployed packages", (Throwable)e);
                ServiceContext.getContext().setStatus(GCUBEServiceContext.Status.FAILED);
            }
        }
    }

    protected class HDeployerStateScheduler
    extends GCUBEScheduledHandler {
        public HDeployerStateScheduler(long interval, GCUBEScheduledHandler.Mode mode) {
            super(interval, mode, new GCUBEHandler[0]);
        }

        protected boolean repeat(Exception exception, int exceptionCount) {
            if (exception != null) {
                this.logger.warn((Object)("Failed to create the deployer resource (attempt " + exceptionCount + " out of 20)"), (Throwable)exception);
                if (exceptionCount >= 20) {
                    this.logger.error((Object)"Max attempts reached, no more chance to register the deployer resource");
                    ServiceContext.getContext().setStatus(GCUBEServiceContext.Status.FAILED);
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    public class DeployerResourceConsumer
    extends GCUBEResource.ResourceConsumer {
        protected void onAddScope(GCUBEResource.AddScopeEvent event) {
            for (GCUBEScope scope : (GCUBEScope[])event.getPayload()) {
                ServiceContext.this.logger.trace((Object)("Adding Deployer resource to " + scope));
                ServiceContext.getContext().setScope(scope);
                try {
                    ServiceContext.this.resource = (DeployerResource)StatefulPortTypeContext.getContext().getWSHome().create(StatefulPortTypeContext.getContext().makeKey("DeployerState"), new Object[0]);
                    ServiceContext.this.resource.store();
                }
                catch (ResourceException e) {
                    ServiceContext.this.logger.error((Object)"Failed to create the deployer resource ", (Throwable)e);
                    ServiceContext.getContext().setStatus(GCUBEServiceContext.Status.FAILED);
                }
            }
        }
    }
}

