/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.operators.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.common.vremanagement.deployer.impl.contexts.ServiceContext;
import org.gcube.common.vremanagement.deployer.impl.operators.common.BaseScheduler;
import org.gcube.common.vremanagement.deployer.impl.operators.common.DeployException;
import org.gcube.common.vremanagement.deployer.impl.operators.common.Scheduler;
import org.gcube.common.vremanagement.deployer.impl.resources.BasePackage;
import org.gcube.common.vremanagement.deployer.impl.resources.KeyData;

public class RebootScheduler
extends BaseScheduler {
    private static RebootScheduler ref;

    public static synchronized Scheduler getScheduler() throws DeployException {
        if (ref == null) {
            ref = new RebootScheduler();
        }
        return ref;
    }

    @Override
    public void add(BasePackage target) throws DeployException {
        super.add(target);
        try {
            this.serialize();
        }
        catch (IOException e) {
            throw new DeployException(e.getMessage());
        }
    }

    @Override
    public void remove(BasePackage target) throws DeployException {
        super.remove(target);
        try {
            this.serialize();
        }
        catch (IOException e) {
            throw new DeployException(e.getMessage());
        }
    }

    @Override
    public void run(KeyData key) throws DeployException {
    }

    private synchronized void serialize() throws IOException {
        File serializationFile = ServiceContext.getContext().getFile("reboot_scripts", new boolean[]{true});
        HashSet<String> serializedScripts = new HashSet<String>();
        try {
            FileReader fr = new FileReader(serializationFile);
            BufferedReader br = new BufferedReader(fr);
            try {
                String s;
                while ((s = br.readLine()) != null) {
                    serializedScripts.add(s);
                }
                fr.close();
                this.logger.info((Object)"Appeding the scripts to the reboot scheduler serialization");
            }
            catch (IOException e) {
                this.logger.error((Object)"Unable to read the reboot scheduler serialization", (Throwable)e);
                this.logger.info((Object)"Creating the reboot scheduler serialization");
            }
        }
        catch (FileNotFoundException e) {
            this.logger.info((Object)"Creating the reboot scheduler serialization");
        }
        for (Set fileslist : this.scripts.values()) {
            for (File file : fileslist) {
                try {
                    Process p = Runtime.getRuntime().exec("chmod 777 " + file.getAbsolutePath(), new String[0], file.getParentFile());
                    p.waitFor();
                    p.destroy();
                }
                catch (Exception e) {
                    // empty catch block
                }
                serializedScripts.add("cd " + file.getParent() + "; . " + file.getAbsolutePath());
            }
        }
        try {
            StringBuilder content = new StringBuilder();
            BufferedWriter out = new BufferedWriter(new FileWriter(serializationFile, false));
            for (String script : serializedScripts) {
                content.append(script).append("\n");
            }
            out.write(content.toString());
            out.close();
        }
        catch (IOException e) {
            this.logger.error((Object)"Unable to write the reboot scheduler serialization", (Throwable)e);
            throw new IOException("Unable to write the reboot scheduler serialization");
        }
    }

    @Override
    protected List<String> getScriptsToSchedule(BasePackage target) {
        return target.getRebootScripts();
    }
}

