package org.gcube.vremanagement.executor.plugin;


import org.gcube.common.core.utils.handlers.lifetime.Lifetime;
import org.gcube.vremanagement.executor.state.TaskRuntime;

/**
 * Tagging interface for tasks that can be executed by the service.
 * @author Fabio Simeoni (University of Strathclyde)
 */
public interface ExecutorTask extends Lifetime<TaskRuntime> {
	
	/**
	 * Attempts to stop execution.
	 * @throws UnsupportedOperationException if the task cannot be stopped.
	 * @throws Exception if the task could not be stopped.
	 **/
	public void stop() throws UnsupportedOperationException,Exception;
}
