/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.contexts;

import java.io.File;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.GCUBEScheduledHandler;
import org.gcube.vremanagement.resourcemanager.impl.contexts.StatefulPortTypeContext;

public class ServiceContext
extends GCUBEServiceContext {
    static ServiceContext cache = new ServiceContext();

    public static String getReportingPTName() {
        return "gcube/vremanagement/resourcemanager/reporting";
    }

    public static String getResourceBinderPTName() {
        return "gcube/vremanagement/resourcemanager/binder";
    }

    public static String getScopeControllerPTName() {
        return "gcube/vremanagement/resourcemanager/scopecontroller";
    }

    public static ServiceContext getContext() {
        return cache;
    }

    protected String getJNDIName() {
        return "gcube/vremanagement/ResourceManager/service";
    }

    protected void onReady() throws Exception {
        super.onReady();
        HStateScheduler stateScheduler = new HStateScheduler(10L, GCUBEScheduledHandler.Mode.LAZY);
        stateScheduler.setScheduled(new HState());
        stateScheduler.run();
    }

    public String getConfigurationFileAbsolutePath(String relativepath) {
        File file = super.getFile(relativepath, new boolean[]{false});
        if (!file.exists() || file.isDirectory()) {
            file.mkdirs();
        }
        return file.getAbsolutePath();
    }

    public static class IllegalServiceScopeException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public IllegalServiceScopeException(String message) {
            super(message);
        }
    }

    protected class HState
    extends GCUBEHandler<Object> {
        public void run() throws Exception {
            for (GCUBEScope scope : ServiceContext.getContext().getInstance().getScopes().values()) {
                ServiceContext.getContext().setScope(scope);
                StatefulPortTypeContext.getContext().getWSHome().create(StatefulPortTypeContext.getContext().makeKey("ManagerState"), new Object[0]);
            }
        }
    }

    protected class HStateScheduler
    extends GCUBEScheduledHandler {
        public HStateScheduler(long interval, GCUBEScheduledHandler.Mode mode) {
            super(interval, mode, new GCUBEHandler[0]);
        }

        protected boolean repeat(Exception exception, int exceptionCount) {
            if (exception != null) {
                this.logger.warn((Object)("Failed to create the ResourceManager resource (attempt " + exceptionCount + " out of 20)"), (Throwable)exception);
                if (exceptionCount >= 20) {
                    this.logger.error((Object)"Max attempts reached, no more chance to register the ResourceManager resource, the service startup failed");
                    ServiceContext.getContext().setStatus(GCUBEServiceContext.Status.FAILED);
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

