/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.operators;

import org.gcube.common.core.contexts.GCUBEContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcemanager.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcemanager.impl.operators.Operator;
import org.gcube.vremanagement.resourcemanager.impl.operators.OperatorConfig;
import org.gcube.vremanagement.resourcemanager.impl.operators.ScopedResourceManagerOperator;
import org.gcube.vremanagement.resourcemanager.impl.state.ScopeState;
import org.gcube.vremanagement.resourcemanager.stubs.binder.RemoveResourcesParameters;
import org.gcube.vremanagement.resourcemanager.stubs.binder.ResourceList;

public class RemoveResourcesOperator
extends Operator {
    protected final GCUBELog logger = new GCUBELog((Object)this, (GCUBEContext)ServiceContext.getContext());
    private OperatorConfig configuration;
    private RemoveResourcesParameters resourceList;

    public RemoveResourcesOperator(ScopeState scopeState, OperatorConfig configuration, RemoveResourcesParameters resourceList) {
        this.configuration = configuration;
        this.resourceList = resourceList;
        this.scopeState = scopeState;
    }

    @Override
    public void exec() throws Exception {
        ResourceList resources = this.resourceList.getResources();
        if (resources == null || resources.getResource().length == 0) {
            this.logger.warn((Object)"The list of resource to add is empty");
        } else {
            try {
                new ScopedResourceManagerOperator(this.scopeState, this.configuration, resources, Operator.ACTION.REMOVE).run();
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to manage the given resource(s)", (Throwable)e);
                throw new Exception("Unable to manage the given resource(s)", e);
            }
        }
    }
}

