/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.state;

import java.util.HashMap;
import java.util.Map;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.vremanagement.resourcemanager.impl.state.RawScopeState;
import org.gcube.vremanagement.resourcemanager.impl.state.VirtualNode;

public class VirtualNodeList {
    Map<String, VirtualNode> listByName;
    Map<String, VirtualNode> listByID;
    GCUBEScope scope;
    private final String stateTag = "NODES";

    public VirtualNodeList(GCUBEScope scope) {
        this.scope = scope;
        this.listByName = new HashMap<String, VirtualNode>();
        this.listByID = new HashMap<String, VirtualNode>();
    }

    void loadFromState(RawScopeState rawState) {
        if (rawState.data.containsKey("NODES")) {
            this.listByName = (Map)rawState.data.get("NODES");
            for (VirtualNode node : this.listByName.values()) {
                this.listByID.put(node.getID(), node);
            }
        }
    }

    void storeToState(RawScopeState rawState) {
        rawState.data.put("NODES", this.listByName);
    }

    void addNode(VirtualNode node) {
        this.listByName.put(node.getName(), node);
        this.listByID.put(node.getID(), node);
    }

    public VirtualNode getNode(String name) throws VirtualNode.NoGHNFoundException {
        if (!this.listByName.containsKey(name)) {
            VirtualNode node = VirtualNode.fromName(name, this.scope);
            if (GHNContext.getContext().getName().equalsIgnoreCase(node.getName())) {
                throw new VirtualNode.NoGHNFoundException("cannot virtualize the GHN (name=" + node.getName() + ") on which Resource Manager is running");
            }
            this.addNode(node);
        }
        return this.listByName.get(name);
    }

    VirtualNode getNodeById(String id) throws VirtualNode.NoGHNFoundException {
        if (!this.listByID.containsKey(id)) {
            VirtualNode node = VirtualNode.fromID(id, this.scope);
            if (GHNContext.getContext().getName().equalsIgnoreCase(node.getName())) {
                throw new VirtualNode.NoGHNFoundException("cannot virtualize the GHN (name=" + node.getName() + ") on which Resource Manager is running");
            }
            this.addNode(node);
            return node;
        }
        return this.listByID.get(id);
    }
}

