/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.impl.contexts;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcebroker.impl.configuration.BrokerConfiguration;
import org.gcube.vremanagement.resourcebroker.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcebroker.impl.resources.ResourceStorageManager;
import org.gcube.vremanagement.resourcebroker.impl.services.GHNReservationHandler;
import org.gcube.vremanagement.resourcebroker.impl.support.threads.TPersistentResourceRefresh;
import org.gcube.vremanagement.resourcebroker.impl.support.threads.TRevokeReservations;
import org.gcube.vremanagement.resourcebroker.impl.support.threads.TimedThreadsStorage;

public class ServiceInitializer {
    private static GCUBELog logger = new GCUBELog(ServiceInitializer.class, BrokerConfiguration.getProperty("LOGGING_PREFIX") + "::[SERV-INIT]");

    public static void start() throws Exception {
        if (BrokerConfiguration.getBoolProperty("ENABLE_REVOKE_RESERVATION_HANDLER")) {
            TRevokeReservations reservationRevoker = new TRevokeReservations((long)BrokerConfiguration.getIntProperty("GHN_RESERVATION_TTL_MINUTES") * 20L * 1000L);
            TimedThreadsStorage.registerThread(reservationRevoker, true);
        }
        if (BrokerConfiguration.getBoolProperty("ENABLE_PERSISTENCE_REFRESH")) {
            TPersistentResourceRefresh persistence = new TPersistentResourceRefresh((long)BrokerConfiguration.getIntProperty("PERSISTENCE_REFRESH_TTL_MINUTES") * 60000L);
            TimedThreadsStorage.registerThread(persistence, true);
        }
        if (BrokerConfiguration.getBoolProperty("PREFETCH_GHNS")) {
            new Thread(){

                @Override
                public void run() {
                    boolean done = false;
                    while (!done) {
                        try {
                            1.sleep(10000L);
                        }
                        catch (InterruptedException e1) {
                            // empty catch block
                        }
                        logger.debug((Object)"[CTX-INIT] Prefetching GHN information from IS.");
                        logger.info((Object)"[INFO] This functionality can be disabled by setting PREFETCH_GHNS=false in the $GLOBUS_LOCATION/etc/org.gcube.vremanagement.resourcebroker/broker.properties file.");
                        if (ServiceContext.getContext().getInstance().getScopes().values().size() == 0) {
                            return;
                        }
                        for (GCUBEScope scope : ServiceContext.getContext().getInstance().getScopes().values()) {
                            logger.debug((Object)("[CTX-INIT] Prefetching GHN information from IS for scope " + scope));
                            try {
                                GHNReservationHandler.getInstance().getGlobalGHNsForScope(scope, false);
                                done = true;
                            }
                            catch (Exception e) {}
                        }
                    }
                }
            }.start();
        }
    }

    public static void stop() {
        logger.debug((Object)"Shutting down the ResourceBroker");
        logger.debug((Object)"Storing persistent resource");
        try {
            ResourceStorageManager.INSTANCE.storeScores();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        logger.debug((Object)"[CTX-STOP] Shutting down");
        TimedThreadsStorage.stopAll();
    }
}

