/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.impl.planbuilders.generictasks;

import java.util.List;
import java.util.Vector;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanBuilderElem;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanBuilderException;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanBuilderTask;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanExceptionMessages;
import org.gcube.vremanagement.resourcebroker.impl.services.GHNReservationHandler;
import org.gcube.vremanagement.resourcebroker.impl.support.types.GHNDescriptor;
import org.gcube.vremanagement.resourcebroker.utils.assertions.Assertion;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PackageElem;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PackageGroup;

public class PreselectedGHNTask
extends PlanBuilderTask {
    @Override
    public final PlanBuilderElem makeDecision(PlanBuilderElem input) throws PlanBuilderException {
        Assertion<PlanBuilderException> checker = new Assertion<PlanBuilderException>();
        checker.validate(input != null, new PlanBuilderException(PlanExceptionMessages.INVALID_REQUEST));
        checker.validate(input.getRequest() != null, new PlanBuilderException(PlanExceptionMessages.INVALID_REQUEST));
        if (input.getRequest().getPackageGroups() == null || input.getRequest().getPackageGroups().size() == 0) {
            return input;
        }
        List pkgGroups = input.getRequest().getPackageGroups();
        Vector<PackageGroup> pkgGroupsToRemove = new Vector<PackageGroup>();
        for (PackageGroup pg : pkgGroups) {
            if (pg.getGHN() == null || pg.getPackages() == null || pg.getPackages().size() <= 0) continue;
            GHNReservationHandler resHandler = GHNReservationHandler.getInstance();
            GHNDescriptor ghn = null;
            try {
                ghn = resHandler.getGHNByID(this.identifier, GCUBEScope.getScope((String)input.getRequest().getScope()), pg.getGHN());
                if (ghn == null) {
                    throw new PlanBuilderException(PlanExceptionMessages.INVALID_GHNS, pg, "Required GHN: " + pg.getGHN());
                }
            }
            catch (GCUBEFault e) {
                throw new PlanBuilderException(PlanExceptionMessages.INVALID_GHNS, pg, "Required GHN: " + pg.getGHN());
            }
            try {
                resHandler.reserveGHN(this.identifier, ghn);
            }
            catch (GCUBEFault e) {
                throw new PlanBuilderException(PlanExceptionMessages.REQUIRED_GHN_LOCKED, pg, e.getFaultMessage());
            }
            PackageGroup pckGrp = input.getResponse().createPackageGroup(pg.getServiceName());
            pckGrp.setGHN(pg.getGHN());
            for (PackageElem p : pg.getPackages()) {
                pckGrp.addPackage(p);
                pckGrp.setID(pg.getID());
            }
            pkgGroupsToRemove.add(pg);
        }
        if (pkgGroupsToRemove != null && pkgGroupsToRemove.size() > 0) {
            for (PackageGroup pgToRemove : pkgGroupsToRemove) {
                input.getRequest().getPackageGroups().remove(pgToRemove);
            }
        }
        return input;
    }
}

