/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.local.testsuite;

import java.util.List;
import java.util.Vector;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.vremanagement.resourcebroker.impl.support.types.GHNDescriptor;

public class GetGHNsAlive {
    public static void main(String[] args) throws Exception {
        String query = "let $now := current-dateTime()\nfor $GHNs in collection(\"/db/Profiles/GHN\")//Document/Data/child::*[local-name()='Profile']/Resource\nlet $RIs := collection(\"/db/Profiles/RunningInstance\")//Document/Data/child::*[local-name()='Profile']/Resource[Profile/GHN/string(@UniqueID)=$GHNs/ID]\nlet $lastTestTimeDuration := xs:dateTime($now) - xs:dateTime($GHNs/Profile/GHNDescription/LastUpdate)\nlet $totalminutes := ceiling($lastTestTimeDuration div xdt:dayTimeDuration('PT1M'))\nwhere $GHNs/Profile/GHNDescription/Type eq 'Dynamic'\n\tand $totalminutes le 40\n\tand count($RIs) gt 0\nreturn\n<RIONGHN>\n{$GHNs/ID}\n\t<AllocatedRI>{count($RIs)}</AllocatedRI>\n\t{$GHNs/Profile/GHNDescription/LastUpdate}\n\t<UpdateMinutesElapsed>{$totalminutes}</UpdateMinutesElapsed>\n\t<ProfileXML>\n\t    {$GHNs/Scopes}\n\t    {$GHNs/Profile/GHNDescription}\n\t    {$GHNs/Profile/Site}\n\t</ProfileXML>\n</RIONGHN>";
        GCUBEScope queryScope = GCUBEScope.getScope((String)"/gcube/devsec");
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBEGenericQuery isQuery = null;
        isQuery = (GCUBEGenericQuery)client.getQuery(GCUBEGenericQuery.class);
        isQuery.setExpression("let $now := current-dateTime()\nfor $GHNs in collection(\"/db/Profiles/GHN\")//Document/Data/child::*[local-name()='Profile']/Resource\nlet $RIs := collection(\"/db/Profiles/RunningInstance\")//Document/Data/child::*[local-name()='Profile']/Resource[Profile/GHN/string(@UniqueID)=$GHNs/ID]\nlet $lastTestTimeDuration := xs:dateTime($now) - xs:dateTime($GHNs/Profile/GHNDescription/LastUpdate)\nlet $totalminutes := ceiling($lastTestTimeDuration div xdt:dayTimeDuration('PT1M'))\nwhere $GHNs/Profile/GHNDescription/Type eq 'Dynamic'\n\tand $totalminutes le 40\n\tand count($RIs) gt 0\nreturn\n<RIONGHN>\n{$GHNs/ID}\n\t<AllocatedRI>{count($RIs)}</AllocatedRI>\n\t{$GHNs/Profile/GHNDescription/LastUpdate}\n\t<UpdateMinutesElapsed>{$totalminutes}</UpdateMinutesElapsed>\n\t<ProfileXML>\n\t    {$GHNs/Scopes}\n\t    {$GHNs/Profile/GHNDescription}\n\t    {$GHNs/Profile/Site}\n\t</ProfileXML>\n</RIONGHN>");
        System.out.println("*** Applying query to SCOPE [" + queryScope.toString() + "]");
        System.out.println("*** Evaluating: " + isQuery.getExpression());
        List results = client.execute((ISQuery)isQuery, queryScope);
        Vector<GHNDescriptor> retval = new Vector<GHNDescriptor>();
        for (XMLResult elem : results) {
            try {
                List riNums = elem.evaluate("/RIONGHN/AllocatedRI/text()");
                List ghnIDs = elem.evaluate("/RIONGHN/ID/text()");
                GHNDescriptor descr = new GHNDescriptor(Integer.parseInt((String)riNums.get(0)), (String)ghnIDs.get(0), queryScope, elem);
                retval.add(descr);
                System.out.println("*** adding descriptor: " + descr.getID() + " load[" + descr.getLoadLast1M() + ", " + descr.getLoadLast5M() + ", " + descr.getLoadLast15M() + "]");
            }
            catch (XMLResult.ISResultEvaluationException e) {
                e.printStackTrace();
            }
        }
        System.out.println(retval);
    }
}

