/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.local.testsuite;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.vremanagement.resourcebroker.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcebroker.local.testsuite.StandaloneISQueryTestConf;
import org.gcube.vremanagement.resourcebroker.utils.performance.PerformanceMonitor;

public class StandaloneISQueryTest
extends GCUBEPortType {
    private PerformanceMonitor timer = new PerformanceMonitor();
    private GCUBEClientLog logger = null;
    private StandaloneISQueryTestConf conf = new StandaloneISQueryTestConf();

    public StandaloneISQueryTest() {
        this.logger = new GCUBEClientLog(StandaloneISQueryTest.class, new Properties[0]);
    }

    protected final Options buildMenu() {
        Option help = new Option("h", "help", false, "print this message.");
        Option about = new Option("about", "give information about this product.");
        Option version = new Option("version", "print the version information.");
        Option scope = new Option("s", "scope", true, "specify scope to use for quering the IS. The default value is set to: " + this.conf.scope.getName());
        scope.setArgName("scope");
        Option output = new Option("o", "output", true, "the file where the output will be stored. By default it will be printed on the standard output.");
        Options options = new Options();
        options.addOption(help);
        options.addOption(about);
        options.addOption(version);
        options.addOption(scope);
        options.addOption(output);
        return options;
    }

    private int handleInput(String[] args) {
        Options options = this.buildMenu();
        PosixParser parser = new PosixParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("about")) {
                System.out.println("****************************************************************************\n*  This software is part of the gCube Project.\n*  Site: http://www.gcube-system.org/\n****************************************************************************\n* The gCube/gCore software is licensed as Free Open Source software\n* conveying to the EUPL (http://ec.europa.eu/idabc/eupl).\n* The software and documentation is provided by its authors/distributors\n* \"as is\" and no expressed or\n* implied warranty is given for its use, quality or fitness for a\n* particular case.\n****************************************************************************\n* Daniele Strollo (ISTI-CNR)\n****************************************************************************\n");
                return -1;
            }
            if (line.hasOption("version")) {
                System.out.println(StandaloneISQueryTest.class.getSimpleName() + " version " + this.conf.CURRENT_VERSION);
                return -1;
            }
            if (line.hasOption("s")) {
                System.out.println("Setting GCUBEScope to... " + line.getOptionValue("scope"));
                this.conf.scope = GCUBEScope.getScope((String)line.getOptionValue("scope"));
            }
            if (line.hasOption("o")) {
                System.out.println("Setting output file to... " + line.getOptionValue("output"));
                this.conf.output = new PrintStream(new File(line.getOptionValue("output")));
            }
            if (line.hasOption("help") || line.getArgs().length < 1) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(StandaloneISQueryTest.class.getSimpleName() + " [OPTION]... <QUERY_FILE>", "Check in the tests folder for some samples.", options, "");
                return -1;
            }
            this.conf.queryFile = line.getArgs()[0];
        }
        catch (Exception exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage());
            return -1;
        }
        return 0;
    }

    public final void doJob(String query) {
        this.timer.start();
        this.logger.debug((Object)"*** ISClientRequester accessing the IS");
        List results = null;
        try {
            this.logger.info((Object)("\nExecuting query: \n" + query));
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBEGenericQuery isQuery = null;
            isQuery = (GCUBEGenericQuery)client.getQuery(GCUBEGenericQuery.class);
            isQuery.setExpression(query);
            this.logger.debug((Object)("*** Applying query to SCOPE [" + this.conf.scope.toString() + "]"));
            results = client.execute((ISQuery)isQuery, this.conf.scope);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conf.output.println("*********************************************************************************");
        this.conf.output.println("QUERY: \n" + query);
        this.conf.output.println("SCOPE: " + this.conf.scope);
        this.conf.output.println("*********************************************************************************");
        if (results == null || results.isEmpty()) {
            this.conf.output.println("NO RESULTS!!! \n\n");
        } else {
            this.conf.output.println(results + "\n\n");
        }
        this.timer.stop();
    }

    public static void main(String[] args) throws Exception {
        StandaloneISQueryTest tester = new StandaloneISQueryTest();
        int result = tester.handleInput(args);
        if (result == -1) {
            return;
        }
        BufferedReader in = new BufferedReader(new FileReader(tester.conf.queryFile));
        StringBuilder query = null;
        String currLine = null;
        while ((currLine = in.readLine()) != null) {
            if (currLine.trim().length() > 0) {
                String string = currLine.trim();
                tester.conf.getClass();
                if (string.startsWith("#")) continue;
            }
            if (currLine.trim().length() == 0) continue;
            query = new StringBuilder(currLine);
            while ((currLine = in.readLine()) != null && currLine.trim().length() != 0) {
                String string = currLine.trim();
                tester.conf.getClass();
                if (string.startsWith("#")) break;
                query.append("\n" + currLine);
            }
            tester.doJob(query.toString());
        }
    }

    protected final GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }
}

