/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.impl.services;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Vector;
import org.apache.xerces.parsers.DOMParser;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.QueryParameter;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcebroker.impl.configuration.BrokerConfiguration;
import org.gcube.vremanagement.resourcebroker.impl.support.queries.QueryLoader;
import org.gcube.vremanagement.resourcebroker.impl.support.queries.QueryPath;
import org.gcube.vremanagement.resourcebroker.utils.assertions.Assertion;
import org.gcube.vremanagement.resourcebroker.utils.console.PrettyFormatter;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PackageElem;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.requirements.Requirement;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.requirements.RequirementElemPath;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.requirements.RequirementRelationType;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ISRequirementsRequester {
    private static GCUBELog logger = new GCUBELog(ISRequirementsRequester.class, BrokerConfiguration.getProperty("LOGGING_PREFIX"));

    public static final List<Requirement> getRequirements(GCUBEScope queryScope, PackageElem pkg) throws Exception {
        Assertion<GCUBEFault> checker = new Assertion<GCUBEFault>();
        checker.validate(queryScope != null, new GCUBEFault(new String[]{"Invalid scope"}));
        checker.validate(pkg != null && pkg.getServiceClass() != null && pkg.getServiceName() != null && pkg.getPackageName() != null, new GCUBEFault(new String[]{"Invalid package param"}));
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBEGenericQuery isQuery = null;
        isQuery = (GCUBEGenericQuery)client.getQuery(GCUBEGenericQuery.class);
        isQuery.setExpression(QueryLoader.getQuery(QueryPath.GET_SERVICE_REQS));
        isQuery.addParameters(new QueryParameter[]{new QueryParameter("SERVICE_CLASS", pkg.getServiceClass())});
        isQuery.addParameters(new QueryParameter[]{new QueryParameter("SERVICE_NAME", pkg.getServiceName())});
        isQuery.addParameters(new QueryParameter[]{new QueryParameter("SERVICE_VERSION", pkg.getServiceVersion())});
        isQuery.addParameters(new QueryParameter[]{new QueryParameter("PKG_NAME", pkg.getPackageName())});
        List results = client.execute((ISQuery)isQuery, queryScope);
        if (results == null) {
            return null;
        }
        logger.info((Object)(PrettyFormatter.bold("[IS-REQS]") + "found: " + PrettyFormatter.underlined("[" + results.size() + "] matching elems")));
        if (results != null && results.size() > 0) {
            List<Requirement> reqs = new Vector<Requirement>();
            String rawRequirements = null;
            for (XMLResult elem : results) {
                try {
                    rawRequirements = (String)elem.evaluate("/RequirementQuery/Results/Result/GHNRequirements").get(0);
                }
                catch (XMLResult.ISResultEvaluationException e) {
                    continue;
                }
                logger.info((Object)rawRequirements);
                reqs = ISRequirementsRequester.convertRowReqs(rawRequirements);
                logger.info((Object)(PrettyFormatter.bold("[IS-REQS]") + "found: " + PrettyFormatter.underlined("[" + reqs.size() + "] requirements for matching elems")));
            }
            return reqs;
        }
        return null;
    }

    private static List<Requirement> convertRowReqs(String rawRequirements) {
        if (rawRequirements == null || rawRequirements.trim().length() == 0) {
            return null;
        }
        Vector<Requirement> retval = new Vector<Requirement>();
        try {
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(new StringReader(rawRequirements)));
            Document doc = parser.getDocument();
            NodeList ns = doc.getElementsByTagName("Requirement");
            for (int i = 0; i < ns.getLength(); ++i) {
                try {
                    String key;
                    Node node = ns.item(i);
                    NamedNodeMap attrs = node.getAttributes();
                    String operator = attrs.getNamedItem("operator").getNodeValue();
                    RequirementRelationType convertedOperator = null;
                    if (operator != null && operator.trim().length() > 0) {
                        if (operator.trim().compareToIgnoreCase("le") == 0) {
                            convertedOperator = RequirementRelationType.LESS_OR_EQUAL;
                        }
                        if (operator.trim().compareToIgnoreCase("eq") == 0) {
                            convertedOperator = RequirementRelationType.EQUAL;
                        }
                        if (operator.trim().compareToIgnoreCase("exist") == 0) {
                            convertedOperator = RequirementRelationType.CONTAINS;
                        }
                        if (operator.trim().compareToIgnoreCase("gt") == 0) {
                            convertedOperator = RequirementRelationType.GREATER;
                        }
                        if (operator.trim().compareToIgnoreCase("ge") == 0) {
                            convertedOperator = RequirementRelationType.GREATER_OR_EQUAL;
                        }
                        if (operator.trim().compareToIgnoreCase("ne") == 0) {
                            convertedOperator = RequirementRelationType.NOT_EQUAL;
                        }
                        if (operator.trim().compareToIgnoreCase("lt") == 0) {
                            convertedOperator = RequirementRelationType.LESS;
                        }
                    }
                    if ((key = attrs.getNamedItem("requirement").getNodeValue()) != null && key.trim().length() > 0) {
                        try {
                            retval.add(new Requirement(RequirementElemPath.valueOf((String)attrs.getNamedItem("category").getNodeValue()), attrs.getNamedItem("requirement").getNodeValue(), convertedOperator, attrs.getNamedItem("value").getNodeValue()));
                        }
                        catch (IllegalArgumentException e) {}
                        continue;
                    }
                    try {
                        retval.add(new Requirement(RequirementElemPath.valueOf((String)attrs.getNamedItem("category").getNodeValue()), convertedOperator, attrs.getNamedItem("value").getNodeValue()));
                    }
                    catch (IllegalArgumentException e) {}
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            return retval;
        }
        catch (SAXException e) {
            logger.error((Object)e);
            return null;
        }
        catch (IOException e) {
            logger.error((Object)e);
            return null;
        }
    }
}

