/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.impl.repositorymanager.maven;

import java.util.List;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.settings.Settings;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.maven.MavenEmbedder;

class MavenExecutor {
    private static final GCUBELog logger = new GCUBELog(MavenExecutor.class);

    MavenExecutor() {
    }

    static void exec(MavenExecutionRequest request, Settings settings) throws Exception {
        MavenEmbedder mavenEmbedder = new MavenEmbedder();
        MavenExecutionResult mavenResult = mavenEmbedder.execute(request, settings);
        MavenExecutor.checkResults(mavenResult);
    }

    private static void checkResults(MavenExecutionResult mavenResult) throws Exception {
        if (mavenResult.hasExceptions()) {
            List exceptionList = mavenResult.getExceptions();
            int i = 1;
            for (Throwable exception : exceptionList) {
                logger.info((Object)("Maven Exception n." + i++ + ":\n" + exception));
                if (!(exception instanceof LifecycleExecutionException)) continue;
                logger.info((Object)"exception instanceof org.apache.maven.lifecycle.LifecycleExecutionException ");
                LifecycleExecutionException lifecycleExecutionException = (LifecycleExecutionException)exception;
                if (!(lifecycleExecutionException.getCause() instanceof MultipleArtifactsNotFoundException)) continue;
                MultipleArtifactsNotFoundException multipleArtifactsNotFoundException = (MultipleArtifactsNotFoundException)lifecycleExecutionException.getCause();
                logger.info((Object)"MultipleArtifactsNotFoundException ");
                int j = 1;
                List resolvedArtifacts = multipleArtifactsNotFoundException.getResolvedArtifacts();
                for (DefaultArtifact defaultArtifact : resolvedArtifacts) {
                    logger.info((Object)("Resolved Artifact n. " + j++ + " : " + defaultArtifact));
                }
                j = 1;
                List missingArtifacts = multipleArtifactsNotFoundException.getMissingArtifacts();
                for (DefaultArtifact defaultArtifact : missingArtifacts) {
                    logger.info((Object)("Missing Artifact n. " + j++ + " : " + defaultArtifact));
                }
            }
            throw new Exception((Throwable)exceptionList.get(0));
        }
        logger.info((Object)"MavenExecutionResults are OK, no Exception was returned from the execution of the request");
    }
}

