/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.vremodeler.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.vremanagement.vremodeler.consumers.CollectionConsumer;
import org.gcube.vremanagement.vremodeler.consumers.GHNConsumer;
import org.gcube.vremanagement.vremodeler.consumers.GenericResourceConsumer;
import org.gcube.vremanagement.vremodeler.consumers.RunningInstanceConsumer;
import org.gcube.vremanagement.vremodeler.consumers.RuntimeResourceConsumer;
import org.gcube.vremanagement.vremodeler.db.IStoDBUtil;
import org.gcube.vremanagement.vremodeler.impl.util.ExpiredVREFinderTask;
import org.gcube.vremanagement.vremodeler.impl.util.ServicePair;
import org.gcube.vremanagement.vremodeler.resources.handlers.CollectionHandler;
import org.gcube.vremanagement.vremodeler.resources.handlers.FunctionalityHandler;
import org.gcube.vremanagement.vremodeler.resources.handlers.GHNHandler;
import org.gcube.vremanagement.vremodeler.resources.handlers.GenericResourceHandler;
import org.gcube.vremanagement.vremodeler.resources.handlers.RuntimeResourceHandler;

public class ServiceContext
extends GCUBEServiceContext {
    private static ServiceContext cache = new ServiceContext();
    private static List<ISNotifier.GCUBENotificationTopic> topicToRemove = new ArrayList<ISNotifier.GCUBENotificationTopic>();
    private ArrayList<String> secondaryTypeGenericResourceRequired = new ArrayList();
    private ArrayList<ServicePair> baseServiceForGhn = new ArrayList();

    public static ServiceContext getContext() {
        return cache;
    }

    private ServiceContext() {
    }

    protected String getJNDIName() {
        return "gcube/vremanagement/vremodeler";
    }

    protected void onReady() throws Exception {
        try {
            this.logger.info((Object)("ready event invoked on " + this.getName()));
            this.intializeDB();
            for (GCUBEScope scope : ServiceContext.getContext().getInstance().getScopes().values()) {
                if (scope.getType() != GCUBEScope.Type.VO) continue;
                ExpiredVREFinderTask.get(scope.toString());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"error initializing VREModeler", (Throwable)e);
            this.setStatus(GCUBEServiceContext.Status.FAILED);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void intializeDB() throws Exception {
        ArrayList<ServicePair> baseServiceGhn = new ArrayList<ServicePair>();
        for (String gen : ((String)this.getProperty("BaseRisForSelectableGHN", new boolean[]{true})).split(";")) {
            String[] serviceString = gen.split(",");
            this.logger.trace((Object)("base service: " + serviceString[0] + "," + serviceString[1]));
            baseServiceGhn.add(new ServicePair(serviceString[0], serviceString[1]));
        }
        this.setBaseServiceForGhn(baseServiceGhn);
        try {
            ISNotifier notifier = (ISNotifier)GHNContext.getImplementation(ISNotifier.class);
            for (GCUBEScope scope : ServiceContext.getContext().getInstance().getScopes().values()) {
                ScopeProvider.instance.set(scope.toString());
                if (scope.getType() != GCUBEScope.Type.VO) continue;
                IStoDBUtil.initDB(scope.toString());
                new GHNHandler().initialize();
                new CollectionHandler().initialize();
                FunctionalityHandler functionalityHandler = new FunctionalityHandler();
                functionalityHandler.initialize();
                new GenericResourceHandler().initialize();
                new RuntimeResourceHandler().initialize();
                this.logger.debug((Object)"Service initialized!!");
                ArrayList<ISNotifier.GCUBENotificationTopic> qnameList = new ArrayList<ISNotifier.GCUBENotificationTopic>();
                qnameList.add(GHNConsumer.ghnTopic);
                notifier.registerToISNotification((ISNotifier.BaseNotificationConsumer)new GHNConsumer(scope), qnameList, (GCUBESecurityManager)this, new GCUBEScope[]{scope});
                qnameList = new ArrayList();
                qnameList.add(RunningInstanceConsumer.riTopic);
                notifier.registerToISNotification((ISNotifier.BaseNotificationConsumer)new RunningInstanceConsumer(scope), qnameList, (GCUBESecurityManager)this, new GCUBEScope[]{scope});
                qnameList = new ArrayList();
                qnameList.add(CollectionConsumer.collectionTopic);
                notifier.registerToISNotification((ISNotifier.BaseNotificationConsumer)new CollectionConsumer(scope), qnameList, (GCUBESecurityManager)this, new GCUBEScope[]{scope});
                qnameList = new ArrayList();
                qnameList.add(GenericResourceConsumer.functionalityTopic);
                notifier.registerToISNotification((ISNotifier.BaseNotificationConsumer)new GenericResourceConsumer(scope, functionalityHandler.getFunctionalityResourceId()), qnameList, (GCUBESecurityManager)this, new GCUBEScope[]{scope});
                qnameList = new ArrayList();
                qnameList.add(RuntimeResourceConsumer.runtimeResourceTopic);
                notifier.registerToISNotification((ISNotifier.BaseNotificationConsumer)new RuntimeResourceConsumer(scope), qnameList, (GCUBESecurityManager)this, new GCUBEScope[]{scope});
                this.logger.debug((Object)"consumers registered");
            }
        }
        finally {
            ScopeProvider.instance.reset();
        }
        topicToRemove.add(GHNConsumer.ghnTopic);
        topicToRemove.add(RunningInstanceConsumer.riTopic);
        topicToRemove.add(CollectionConsumer.collectionTopic);
        topicToRemove.add(GenericResourceConsumer.functionalityTopic);
        topicToRemove.add(RuntimeResourceConsumer.runtimeResourceTopic);
    }

    public void onShutdown() throws Exception {
        ISNotifier notifier = (ISNotifier)GHNContext.getImplementation(ISNotifier.class);
        GCUBEScope enteringScope = ServiceContext.getContext().getScope();
        for (GCUBEScope scope : ServiceContext.getContext().getInstance().getScopes().values()) {
            if (scope.getType() == GCUBEScope.Type.VO) {
                ExpiredVREFinderTask.get(scope.toString()).cancel();
            }
            ServiceContext.getContext().setScope(scope);
            notifier.unregisterFromISNotification((GCUBESecurityManager)this, topicToRemove, new GCUBEScope[]{scope});
        }
        ServiceContext.getContext().setScope(enteringScope);
    }

    public ArrayList<String> getSecondaryTypeGenericResourceRequired() {
        return this.secondaryTypeGenericResourceRequired;
    }

    public void setSecondaryTypeGenericResourceRequired(String[] secondaryTypeGenericResourceRequired) {
        Collections.addAll(this.secondaryTypeGenericResourceRequired, secondaryTypeGenericResourceRequired);
    }

    public ArrayList<ServicePair> getBaseServiceForGhn() {
        return this.baseServiceForGhn;
    }

    public void setBaseServiceForGhn(ArrayList<ServicePair> baseServiceForGhn) {
        this.baseServiceForGhn = baseServiceForGhn;
    }
}

