/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.vremodeler.resources.handlers;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import java.io.StringReader;
import java.util.List;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.vremanagement.vremodeler.db.DBInterface;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.FunctionalityPersisted;
import org.gcube.vremanagement.vremodeler.resources.handlers.ResourceHandler;
import org.gcube.vremanagement.vremodeler.resources.kxml.KGCUBEGenericFunctionalityResource;

public class FunctionalityHandler
implements ResourceHandler<FunctionalityPersisted> {
    private static GCUBELog logger = new GCUBELog(FunctionalityHandler.class);
    private String functionalityResourceId;

    @Override
    public void add(FunctionalityPersisted resource) throws Exception {
        this.insert(resource);
    }

    @Override
    public void drop(String resourceId) throws Exception {
    }

    @Override
    public List<FunctionalityPersisted> initialize() throws Exception {
        KGCUBEGenericFunctionalityResource resource = new KGCUBEGenericFunctionalityResource();
        try {
            ISClient queryClient = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)queryClient.getQuery(GCUBEGenericResourceQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/Name", "FuctionalitiesResource"), new AtomicCondition("/Profile/SecondaryType", "VREModelerResource")});
            GCUBEGenericQuery genericQuery = (GCUBEGenericQuery)queryClient.getQuery(GCUBEGenericQuery.class);
            genericQuery.setExpression(query.getExpression());
            resource.load(new StringReader(((XMLResult)queryClient.execute((ISQuery)genericQuery, GCUBEScope.getScope((String)ScopeProvider.instance.get())).get(0)).toString()));
            this.functionalityResourceId = resource.getID();
            logger.debug((Object)("the functionality resource ID is " + this.functionalityResourceId));
            for (FunctionalityPersisted functionality : resource.fromResourceToPersistedList()) {
                this.insert(functionality);
            }
            logger.debug((Object)"functionalities initialized");
        }
        catch (Exception e) {
            logger.error((Object)"Functionality resource not found", (Throwable)e);
            logger.warn((Object)"the service will be initialized without functionalities");
        }
        return null;
    }

    private void insert(FunctionalityPersisted resource) throws Exception {
        Dao functionalityDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), FunctionalityPersisted.class);
        functionalityDao.createOrUpdate((Object)resource);
    }

    public void clearTable() throws Exception {
        TableUtils.clearTable((ConnectionSource)DBInterface.connect(), FunctionalityPersisted.class);
    }

    public String getFunctionalityResourceId() {
        return this.functionalityResourceId;
    }
}

