/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.vremodeler.resources.kxml;

import java.util.ArrayList;
import org.gcube.common.resources.kxml.KGCUBEResource;
import org.gcube.common.resources.kxml.utils.KStringList;
import org.gcube.vremanagement.vremodeler.resources.Functionality;
import org.gcube.vremanagement.vremodeler.resources.ResourceDefinition;
import org.gcube.vremanagement.vremodeler.resources.Service;
import org.gcube.vremanagement.vremodeler.resources.kxml.KResources;
import org.gcube.vremanagement.vremodeler.resources.kxml.KService;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;

public class KFunctionality {
    /*
     * Enabled aggressive block sorting
     */
    public static Functionality load(KXmlParser parser) throws Exception {
        Functionality d = new Functionality();
        boolean mandatory = Boolean.parseBoolean(parser.getAttributeValue(KGCUBEResource.NS, "mandatory"));
        d.setMandatory(mandatory);
        while (true) {
            switch (parser.next()) {
                case 2: {
                    if (parser.getName().equals("Name")) {
                        d.setName(parser.nextText().trim());
                    }
                    if (parser.getName().equals("Description")) {
                        d.setDescription(parser.nextText().trim());
                    }
                    if (parser.getName().equals("Service")) {
                        d.getServices().add(KService.load(parser));
                    }
                    if (parser.getName().equals("Portlets")) {
                        d.setPortlets((ArrayList)KStringList.load((String)"Portlets", (KXmlParser)parser));
                    }
                    if (parser.getName().equals("MandatoryResources")) {
                        d.setMandatoryResources(KResources.load(parser, "MandatoryResources"));
                    }
                    if (!parser.getName().equals("SelectableResources")) break;
                    d.setSelectableResources(KResources.load(parser, "SelectableResources"));
                    break;
                }
                case 3: {
                    if (!parser.getName().equals("Functionality")) break;
                    return d;
                }
                case 1: {
                    throw new Exception("Parsing failed at Functionality");
                }
            }
        }
    }

    public static void store(Functionality component, KXmlSerializer serializer) throws Exception {
        if (component == null) {
            return;
        }
        serializer.startTag(KGCUBEResource.NS, "Functionality");
        serializer.startTag(KGCUBEResource.NS, "Name").text(component.getName()).endTag(KGCUBEResource.NS, "Name");
        serializer.startTag(KGCUBEResource.NS, "Description").text(component.getDescription()).endTag(KGCUBEResource.NS, "Description");
        if (component.getServices().size() != 0) {
            serializer.startTag(KGCUBEResource.NS, "Services");
            for (Service service : component.getServices()) {
                KService.store(service, serializer);
            }
            serializer.endTag(KGCUBEResource.NS, "Services");
        }
        if (component.getMandatoryResources().size() != 0) {
            serializer.startTag(KGCUBEResource.NS, "MandatoryResources");
            for (ResourceDefinition resourceDefinition : component.getMandatoryResources()) {
                KResources.store(resourceDefinition, serializer);
            }
            serializer.endTag(KGCUBEResource.NS, "MandatoryResources");
        }
        if (component.getSelectableResources().size() != 0) {
            serializer.startTag(KGCUBEResource.NS, "SelectableResources");
            for (ResourceDefinition resourceDefinition : component.getSelectableResources()) {
                KResources.store(resourceDefinition, serializer);
            }
            serializer.endTag(KGCUBEResource.NS, "SelectableResources");
        }
        if (component.getServices().size() != 0) {
            KStringList.store((String)"Portlets", (String)"Portlet", component.getPortlets(), (KXmlSerializer)serializer);
        }
        serializer.endTag(KGCUBEResource.NS, "Functionality");
    }
}

