/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resources.federation.fhnmanager.cl.fwsimpl;

import java.util.Collection;
import java.util.Set;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.AsyncProxyDelegate;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.ServiceException;
import org.gcube.resources.federation.fhnmanager.api.FHNManager;
import org.gcube.resources.federation.fhnmanager.api.exception.FHNManagerException;
import org.gcube.resources.federation.fhnmanager.api.type.Node;
import org.gcube.resources.federation.fhnmanager.api.type.OccopusInfrastructure;
import org.gcube.resources.federation.fhnmanager.api.type.ResourceTemplate;
import org.gcube.resources.federation.fhnmanager.api.type.ServiceProfile;
import org.gcube.resources.federation.fhnmanager.api.type.VMProvider;

public class FHNManagerClient
implements FHNManager {
    private final AsyncProxyDelegate<WebTarget> delegate;

    public FHNManagerClient(ProxyDelegate<WebTarget> config) {
        this.delegate = new AsyncProxyDelegate(config);
    }

    public VMProvider getVMProviderbyId(final String vmProviderId) throws FHNManagerException {
        Call<WebTarget, VMProvider> call = new Call<WebTarget, VMProvider>(){

            public VMProvider call(WebTarget endpoint) throws Exception {
                return (VMProvider)endpoint.path("vmproviders").path(vmProviderId).request(new String[]{"text/xml"}).get((GenericType)new GenericType<VMProvider>(){});
            }
        };
        try {
            return (VMProvider)this.delegate.make((Call)call);
        }
        catch (FHNManagerException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public Set<VMProvider> findVMProviders(final String serviceProfileId) throws FHNManagerException {
        Call<WebTarget, Set<VMProvider>> call = new Call<WebTarget, Set<VMProvider>>(){

            public Set<VMProvider> call(WebTarget endpoint) throws Exception {
                return (Set)endpoint.path("vmproviders").queryParam("serviceProfileId", new Object[]{serviceProfileId}).request(new String[]{"text/xml"}).get((GenericType)new GenericType<Set<VMProvider>>(){});
            }
        };
        try {
            return (Set)this.delegate.make((Call)call);
        }
        catch (FHNManagerException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public Set<ServiceProfile> allServiceProfiles() throws FHNManagerException {
        Call<WebTarget, Set<ServiceProfile>> call = new Call<WebTarget, Set<ServiceProfile>>(){

            public Set<ServiceProfile> call(WebTarget endpoint) throws Exception {
                return (Set)endpoint.path("serviceprofiles").request(new String[]{"text/xml"}).get((GenericType)new GenericType<Set<ServiceProfile>>(){});
            }
        };
        try {
            return (Set)this.delegate.make((Call)call);
        }
        catch (FHNManagerException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void startNode(final String nodeId) throws FHNManagerException {
        Call<WebTarget, Void> call = new Call<WebTarget, Void>(){

            public Void call(WebTarget endpoint) throws Exception {
                endpoint.path("nodes/start").queryParam("nodeId", new Object[]{nodeId}).request(new String[]{"text/xml"}).get();
                return null;
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (FHNManagerException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void stopNode(final String nodeId) throws FHNManagerException {
        Call<WebTarget, Void> call = new Call<WebTarget, Void>(){

            public Void call(WebTarget endpoint) throws Exception {
                endpoint.path("nodes/stop").queryParam("nodeId", new Object[]{nodeId}).request(new String[]{"text/xml"}).get();
                return null;
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (FHNManagerException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void deleteNode(final String nodeId) throws FHNManagerException {
        Call<WebTarget, Void> call = new Call<WebTarget, Void>(){

            public Void call(WebTarget endpoint) throws Exception {
                endpoint.path("nodes/delete").queryParam("nodeId", new Object[]{nodeId}).request(new String[]{"text/xml"}).get();
                return null;
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (FHNManagerException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public Collection<ResourceTemplate> findResourceTemplate(final String vmProviderId) throws FHNManagerException {
        Call<WebTarget, Collection<ResourceTemplate>> call = new Call<WebTarget, Collection<ResourceTemplate>>(){

            public Collection<ResourceTemplate> call(WebTarget endpoint) throws Exception {
                return (Collection)endpoint.path("resourceTemplate").queryParam("vmProviderId", new Object[]{vmProviderId}).request(new String[]{"text/xml"}).get((GenericType)new GenericType<Collection<ResourceTemplate>>(){});
            }
        };
        try {
            return (Collection)this.delegate.make((Call)call);
        }
        catch (FHNManagerException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public Node getNodeById(final String nodeId) throws FHNManagerException {
        Call<WebTarget, Node> call = new Call<WebTarget, Node>(){

            public Node call(WebTarget endpoint) throws Exception {
                return (Node)endpoint.path("nodes").path(nodeId).request(new String[]{"text/xml"}).get((GenericType)new GenericType<Node>(){});
            }
        };
        try {
            return (Node)this.delegate.make((Call)call);
        }
        catch (FHNManagerException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public Set<Node> findNodes(final String serviceProfileId, final String vmProviderId) throws FHNManagerException {
        Call<WebTarget, Set<Node>> call = new Call<WebTarget, Set<Node>>(){

            public Set<Node> call(WebTarget endpoint) throws Exception {
                System.out.println(endpoint.path("nodes").queryParam("serviceProfileId", new Object[]{serviceProfileId}).queryParam("vmProviderId", new Object[]{vmProviderId}));
                return (Set)endpoint.path("nodes").queryParam("serviceProfileId", new Object[]{serviceProfileId}).queryParam("vmProviderId", new Object[]{vmProviderId}).request(new String[]{"text/xml"}).get((GenericType)new GenericType<Set<Node>>(){});
            }
        };
        try {
            return (Set)this.delegate.make((Call)call);
        }
        catch (FHNManagerException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public Node createNode(final String vmProviderId, final String serviceProfileId, final String resourceTemplateId) throws FHNManagerException {
        Call<WebTarget, Node> call = new Call<WebTarget, Node>(){

            public Node call(WebTarget endpoint) throws Exception {
                Node n = (Node)endpoint.path("nodes/create").queryParam("vmProviderId", new Object[]{vmProviderId}).queryParam("serviceProfileId", new Object[]{serviceProfileId}).queryParam("resourceTemplateId", new Object[]{resourceTemplateId}).request(new String[]{"text/xml"}).get((GenericType)new GenericType<Node>(){});
                return n;
            }
        };
        try {
            return (Node)this.delegate.make((Call)call);
        }
        catch (FHNManagerException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public OccopusInfrastructure createInfrastructureByTemplate(final String infrastructureTemplateId) throws FHNManagerException {
        Call<WebTarget, OccopusInfrastructure> call = new Call<WebTarget, OccopusInfrastructure>(){

            public OccopusInfrastructure call(WebTarget endpoint) throws Exception {
                OccopusInfrastructure n = (OccopusInfrastructure)endpoint.path("infrastructures/create").queryParam("infrastructureTemplateId", new Object[]{infrastructureTemplateId}).request(new String[]{"text/xml"}).get((GenericType)new GenericType<OccopusInfrastructure>(){});
                return n;
            }
        };
        try {
            return (OccopusInfrastructure)this.delegate.make((Call)call);
        }
        catch (FHNManagerException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void destroyInfrastructure(final String infrastructureId) {
        Call<WebTarget, Void> call = new Call<WebTarget, Void>(){

            public Void call(WebTarget endpoint) throws Exception {
                endpoint.path("infrastructures/delete").queryParam("infrastructureId", new Object[]{infrastructureId}).request(new String[]{"text/xml"}).get();
                return null;
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (FHNManagerException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public OccopusInfrastructure getInfrastructureById(final String infraId) throws FHNManagerException {
        Call<WebTarget, OccopusInfrastructure> call = new Call<WebTarget, OccopusInfrastructure>(){

            public OccopusInfrastructure call(WebTarget endpoint) throws Exception {
                return (OccopusInfrastructure)endpoint.path("infrastructures").path(infraId).request(new String[]{"text/xml"}).get((GenericType)new GenericType<OccopusInfrastructure>(){});
            }
        };
        try {
            return (OccopusInfrastructure)this.delegate.make((Call)call);
        }
        catch (FHNManagerException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public Set<OccopusInfrastructure> getAllInfrastructures() {
        Call<WebTarget, Set<OccopusInfrastructure>> call = new Call<WebTarget, Set<OccopusInfrastructure>>(){

            public Set<OccopusInfrastructure> call(WebTarget endpoint) throws Exception {
                return (Set)endpoint.path("infrastructures").request(new String[]{"text/xml"}).get((GenericType)new GenericType<Set<OccopusInfrastructure>>(){});
            }
        };
        try {
            return (Set)this.delegate.make((Call)call);
        }
        catch (FHNManagerException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }
}

