/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.scan.scanners.url;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gcube.common.scan.resources.ClasspathResource;
import org.gcube.common.scan.resources.FileResource;
import org.gcube.common.scan.scanners.url.URLScanner;

public class DirScanner
implements URLScanner {
    @Override
    public boolean handles(URL url) {
        return "file".equals(url.getProtocol()) && url.toExternalForm().endsWith("/");
    }

    @Override
    public Set<URL> additional(URL url) {
        return Collections.emptySet();
    }

    public Set<ClasspathResource> scan(URL url) throws Exception {
        URI uri = url.toURI();
        File dir = new File(uri.getSchemeSpecificPart());
        if (!(dir.exists() && dir.isDirectory() && dir.canRead())) {
            throw new IllegalArgumentException(dir + " is not readable or is not a directory");
        }
        HashSet<ClasspathResource> resources = new HashSet<ClasspathResource>();
        this.buildClosure(dir, dir, resources);
        return resources;
    }

    private void buildClosure(File root, File dir, Set<ClasspathResource> resources) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.buildClosure(root, f, resources);
                continue;
            }
            String rootPath = root.getPath();
            String path = f.getPath();
            String relativePath = path.substring(rootPath.length() + 1);
            resources.add(new FileResource(rootPath, relativePath));
        }
    }
}

