/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.indexfuse;

import gr.uoa.di.madgik.searchlibrary.operatorlibrary.indexfuse.JoinElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultElement {
    private static Logger logger = LoggerFactory.getLogger((String)ResultElement.class.getName());
    private JoinElement[] elements = null;
    private double rank = 0.0;
    private String id = null;
    private int inserted = 0;
    private boolean sent = false;

    public ResultElement(String id, int cols) {
        this.id = id;
        this.elements = new JoinElement[cols + 1];
    }

    public boolean insertElement(JoinElement element, double weight) {
        short colID = element.getMetaColID();
        if (this.elements[colID] != null) {
            logger.warn("An element for DocID: " + element.getId() + " from the " + colID + "-th RS(received by the operator) for collection:" + element.getCollectionID() + " was already found");
            return false;
        }
        this.elements[colID] = element;
        this.rank += weight * element.getRank();
        ++this.inserted;
        return true;
    }

    public int getInserted() {
        return this.inserted;
    }

    public void tagSent() {
        this.sent = true;
    }

    public boolean isSent() {
        return this.sent;
    }

    public double getRank() {
        return this.rank;
    }

    public String getId() {
        return this.id;
    }
}

