/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.EventEntry;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.EventHandler;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.FIFOScanDispatcher;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.FirstAvailableScanDispatcher;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.OperationMode;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.ReaderHolder;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.ReaderScan;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.RecordBufferEntry;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.ScanDispatcher;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.util.Calendar;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeWorker
extends Thread {
    private Logger logger = LoggerFactory.getLogger((String)MergeWorker.class.getName());
    private Vector<ReaderHolder> readers = null;
    private RecordWriter<Record> writer = null;
    private int[] recordDefinitionOffsets = null;
    private Object synchWriterInit = new Object();
    private OperationMode operationMode;
    private String uid = null;
    private long timeout;
    private TimeUnit timeUnit;
    private int count = 0;
    private long firststop = 0L;
    private StatsContainer stats;

    public MergeWorker(Vector<ReaderHolder> readers, StatsContainer stats, OperationMode operationMode, long timeout, TimeUnit timeUnit, String uid) {
        this.readers = readers;
        this.stats = stats;
        this.operationMode = operationMode;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.uid = uid;
    }

    public void setWriter(RecordWriter<Record> writer) {
        this.writer = writer;
    }

    public void setRecordDefinitionOffsets(int[] recordDefinitionOffsets) {
        this.recordDefinitionOffsets = recordDefinitionOffsets;
    }

    public Object getWriterInitSyncObject() {
        return this.synchWriterInit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long start = Calendar.getInstance().getTimeInMillis();
        this.setName("Merge Worker");
        ArrayBlockingQueue<RecordBufferEntry> recs = null;
        ConcurrentLinkedQueue<EventEntry> events = null;
        try {
            int capacity = 100;
            this.logger.info("Queue capacity for " + this.uid + " is " + capacity);
            recs = new ArrayBlockingQueue<RecordBufferEntry>(capacity);
            events = new ConcurrentLinkedQueue<EventEntry>();
            ReaderScan[] scan = new ReaderScan[this.readers.size()];
            for (int i = 0; i < this.readers.size(); ++i) {
                scan[i] = new ReaderScan(this.readers, i, recs, events, this.timeout, this.timeUnit, this.uid);
            }
            ScanDispatcher dispatcher = this.operationMode == OperationMode.FIFO ? new FIFOScanDispatcher(scan) : new FirstAvailableScanDispatcher(scan);
            dispatcher.start();
            Object object = this.synchWriterInit;
            synchronized (object) {
                while (this.writer == null || this.recordDefinitionOffsets == null) {
                    this.synchWriterInit.wait();
                }
            }
            EventHandler<Record> eventHandler = new EventHandler<Record>(this.writer, events, this.readers.size(), 100);
            this.logger.info("After all readers have initialized, the intermediate buffer of " + this.uid + " contains " + recs.size() + " records");
            boolean finished = false;
            while (!finished) {
                int i;
                if (this.count == 0) {
                    this.firststop = Calendar.getInstance().getTimeInMillis();
                    this.stats.timeToFirstInput(this.firststop - start);
                }
                RecordBufferEntry rbEntry = (RecordBufferEntry)recs.poll(500L, TimeUnit.MILLISECONDS);
                eventHandler.propagateEvents();
                if (rbEntry != null) {
                    Record rec = rbEntry.record;
                    if (this.writer.getStatus() == IBuffer.Status.Close || this.writer.getStatus() == IBuffer.Status.Dispose) {
                        this.logger.info("Consumer side of " + this.uid + " stopped consumption. Notifying all " + this.readers.size() + " readers to stop.");
                        Vector<ReaderHolder> vector = this.readers;
                        synchronized (vector) {
                            for (i = 0; i < this.readers.size(); ++i) {
                                this.readers.get(i).setFinished(true);
                                try {
                                    this.readers.get(i).getReader().close();
                                    continue;
                                }
                                catch (GRS2ReaderException re) {
                                    this.logger.warn("Could not close reader #" + i);
                                }
                            }
                        }
                        recs.clear();
                        break;
                    }
                    int newDefinitionIndex = this.recordDefinitionOffsets[rbEntry.id] + (rec.getDefinitionIndex() == -1 ? 0 : rec.getDefinitionIndex());
                    if (!this.writer.importRecord(rec, newDefinitionIndex, this.timeout, this.timeUnit)) {
                        if (this.writer.getStatus() != IBuffer.Status.Open) break;
                        this.logger.warn("Writer of " + this.uid + " has timed out");
                        break;
                    }
                    ++this.count;
                    eventHandler.increaseProducedRecordCount();
                    continue;
                }
                int count = 0;
                Vector<ReaderHolder> newDefinitionIndex = this.readers;
                synchronized (newDefinitionIndex) {
                    for (i = 0; i < scan.length; ++i) {
                        if (this.readers.get(i).hasFinished()) continue;
                        ++count;
                    }
                }
                if (count != 0) continue;
                finished = true;
            }
            dispatcher.join();
            long closestop = Calendar.getInstance().getTimeInMillis();
            eventHandler.sendPendingFinalEvents(this.count);
            try {
                this.writer.close();
            }
            catch (GRS2WriterException e) {
                this.logger.warn("Could not close writer");
            }
            for (int i = 0; i < this.readers.size(); ++i) {
                try {
                    this.readers.get(i).getReader().close();
                    continue;
                }
                catch (GRS2ReaderException re) {
                    this.logger.warn("Could not close reader #" + i);
                }
            }
            this.stats.timeToComplete(closestop - start);
            this.stats.timeToFirst(this.firststop - start);
            this.stats.productionRate((float)this.count / (float)(closestop - start) * 1000.0f);
            this.stats.producedResults(this.count);
            this.logger.info("MERGE OPERATOR " + this.uid + ":\nProduced first result in " + (this.firststop - start) + " milliseconds\n" + "Produced last result in " + (closestop - start) + " milliseconds\n" + "Produced " + this.count + " records\n" + "Production rate was " + (float)this.count / (float)(closestop - start) * 1000.0f + " records per second");
        }
        catch (Exception e) {
            this.logger.error("Could not complete background merging for " + this.uid + ". Closing", (Throwable)e);
            Vector<ReaderHolder> scan = this.readers;
            synchronized (scan) {
                for (int i = 0; i < this.readers.size(); ++i) {
                    this.readers.get(i).setFinished(true);
                    try {
                        if (this.readers.get(i).getReader().getStatus() == IBuffer.Status.Dispose) continue;
                        this.readers.get(i).getReader().close();
                        continue;
                    }
                    catch (GRS2ReaderException re) {
                        this.logger.warn("Could not close reader #" + i);
                    }
                }
            }
            recs.clear();
            try {
                if (this.writer.getStatus() != IBuffer.Status.Dispose) {
                    this.writer.close();
                }
            }
            catch (Exception ee) {
                this.logger.error("Could not close writer of " + this.uid, (Throwable)ee);
            }
        }
    }
}

