/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.test.filerepeatgenerator;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.FileField;
import gr.uoa.di.madgik.grs.record.field.FileFieldDefinition;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.Calendar;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRepeatGeneratorWorker
extends Thread {
    private static Logger logger = LoggerFactory.getLogger((String)FileRepeatGeneratorWorker.class.getName());
    private RecordWriter<Record> writer = null;
    private URI outLocator = null;
    private int count = 0;
    private String fileName = null;
    private int id;
    private long timeout;
    private TimeUnit timeUnit;
    private Float threshold;
    private File outFile = null;
    private Object synchWriter = null;

    public FileRepeatGeneratorWorker(int count, String fileName, int id, long timeout, TimeUnit timeUnit, Float threshold, File outFile, Object synchWriter) throws Exception {
        RecordWriter baseWriter;
        this.count = count;
        this.fileName = fileName;
        this.id = id;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.threshold = Float.valueOf(threshold != null ? threshold.floatValue() : RecordWriter.DefaultThreshold);
        this.outFile = outFile;
        if (this.threshold.floatValue() < 0.0f || this.threshold.floatValue() > 1.0f) {
            throw new Exception("Invalid threshold value");
        }
        LocalWriterProxy producerProxy = new LocalWriterProxy();
        FileFieldDefinition fileFieldDef = new FileFieldDefinition("ThisIsTheField");
        fileFieldDef.setTransportDirective(IBuffer.TransportDirective.Partial);
        fileFieldDef.setChunkSize(10240);
        RecordDefinition[] defs = new RecordDefinition[]{new GenericRecordDefinition(new FieldDefinition[]{fileFieldDef})};
        this.writer = threshold == null ? (baseWriter = new RecordWriter((IWriterProxy)producerProxy, defs, 100, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor)) : (baseWriter = new RecordWriter((IWriterProxy)producerProxy, defs, 100, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor));
        this.outLocator = producerProxy.getLocator();
        this.synchWriter = synchWriter;
    }

    public URI getLocator() {
        return this.outLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setName("FileRepeatGeneratorWorker #" + this.id);
        int rc = 0;
        long now = Calendar.getInstance().getTimeInMillis();
        Random rnd = new Random(47L);
        BufferedWriter out = null;
        boolean thresholdRecs = false;
        Object thresholdSync = null;
        if (this.outFile != null) {
            try {
                out = new BufferedWriter(new FileWriter(this.outFile));
            }
            catch (IOException e) {
                logger.warn("Could not open output file", (Throwable)e);
            }
        }
        Object e = this.synchWriter;
        synchronized (e) {
            this.synchWriter.notify();
        }
        try {
            while (rc < this.count) {
                GenericRecord outRec;
                block21: {
                    if (this.writer.getStatus() == IBuffer.Status.Close || this.writer.getStatus() == IBuffer.Status.Dispose) {
                        System.out.println("Consumer side stopped consumption. Random generator #" + this.id + " stopping prematurely");
                        break;
                    }
                    if (rc == 1) {
                        System.out.println("Time to first input: " + (Calendar.getInstance().getTimeInMillis() - now));
                    }
                    outRec = new GenericRecord();
                    FileField outField = new FileField(new File(this.fileName));
                    outRec.setFields(new Field[]{outField});
                    try {
                        long startpout = System.currentTimeMillis();
                        if (!this.writer.put((Record)outRec, 60L, TimeUnit.SECONDS)) {
                            logger.warn("Could not write record " + rc + ". Skipping. Available Records = " + this.writer.availableRecords());
                        }
                        break block21;
                    }
                    catch (GRS2WriterException e2) {
                        logger.warn("Could not write record " + rc + ". Skipping. Available Records = " + this.writer.availableRecords(), (Throwable)e2);
                    }
                    catch (Exception e3) {
                        logger.warn("Could not write record " + rc + ". Skipping. Available Records = " + this.writer.availableRecords(), (Throwable)e3);
                    }
                    continue;
                }
                ++rc;
                if (out != null) {
                    try {
                        out.write(((FileField)outRec.getField(0)).getPayload().getPath());
                        out.newLine();
                    }
                    catch (Exception e4) {
                        logger.warn("Could not persist record to output file", (Throwable)e4);
                    }
                }
                if (rc != this.count) continue;
                break;
            }
            this.writer.close();
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e5) {
                    logger.warn("Could not close output file", (Throwable)e5);
                }
            }
        }
        catch (GRS2WriterException e6) {
            logger.warn("Could not close writer");
        }
        long closestop = Calendar.getInstance().getTimeInMillis();
        logger.info("Data generation took " + (closestop - now));
        logger.info("Produced " + rc + " records");
        logger.info("Production rate was " + (float)rc / (float)(closestop - now) * 1000.0f);
    }
}

