/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.indexfuse;

import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.indexfuse.IndexFuseWorker;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.net.URI;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexFuseOp {
    private static Logger logger = LoggerFactory.getLogger((String)IndexFuseOp.class.getName());
    private URI[] contentLocators = null;
    private URI[][] metaLocators = null;
    private StatsContainer stats;
    private double contentWeight = 0.5;
    private double metaWeight = 0.5;
    private String[] colIDs = null;
    public static String ObjectIdFieldNameDef = "objId";
    public static String CollectionFieldNameDef = "collId";
    public static String RankFieldNameDef = "rank";
    private String objectIdFieldName = ObjectIdFieldNameDef;
    private String collectionFieldName = CollectionFieldNameDef;
    private String rankFieldName = RankFieldNameDef;
    private static long TimeoutDef = 60L;
    private static TimeUnit TimeUnitDef = TimeUnit.SECONDS;
    private long timeout = TimeoutDef;
    private TimeUnit timeUnit = TimeUnitDef;

    public IndexFuseOp(URI[] contentLocators, URI[][] metaLocators, String[] colIDs, StatsContainer stats) throws Exception {
        if (contentLocators.length != metaLocators.length) {
            throw new Exception("RS locators for content and metadata don't have the same length. This length defines the number of collections");
        }
        if (contentLocators.length != colIDs.length) {
            throw new Exception("RS locators array for content and colIDs array don't have the same length. This length defines the number of collections");
        }
        this.colIDs = colIDs;
        this.contentLocators = contentLocators;
        this.metaLocators = metaLocators;
        this.stats = stats;
    }

    public IndexFuseOp(URI[] contentLocators, URI[][] metaLocators, String[] colIDs, String objectIdFieldName, String collectionFieldName, String rankFieldName, StatsContainer stats) throws Exception {
        if (contentLocators.length != metaLocators.length) {
            throw new Exception("RS locators for content and metadata don't have the same length. This length defines the number of collections");
        }
        if (contentLocators.length != colIDs.length) {
            throw new Exception("RS locators array for content and colIDs array don't have the same length. This length defines the number of collections");
        }
        this.colIDs = colIDs;
        this.contentLocators = contentLocators;
        this.metaLocators = metaLocators;
        this.objectIdFieldName = objectIdFieldName;
        this.collectionFieldName = collectionFieldName;
        this.rankFieldName = rankFieldName;
        this.stats = stats;
    }

    public IndexFuseOp(URI[] contentLocators, URI[][] metaLocators, String[] colIDs, String objectIdFieldName, String collectionFieldName, String rankFieldName, long timeout, TimeUnit timeUnit, StatsContainer stats) throws Exception {
        if (contentLocators.length != metaLocators.length) {
            throw new Exception("RS locators for content and metadata don't have the same length. This length defines the number of collections");
        }
        if (contentLocators.length != colIDs.length) {
            throw new Exception("RS locators array for content and colIDs array don't have the same length. This length defines the number of collections");
        }
        this.colIDs = colIDs;
        this.contentLocators = contentLocators;
        this.metaLocators = metaLocators;
        this.objectIdFieldName = objectIdFieldName;
        this.collectionFieldName = collectionFieldName;
        this.rankFieldName = rankFieldName;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.stats = stats;
    }

    public URI compute() throws Exception {
        try {
            long startInit = Calendar.getInstance().getTimeInMillis();
            ForwardReader[] contentReaders = new ForwardReader[this.contentLocators.length];
            logger.info("Creating iterators for the locators of the ResultSets");
            for (int i = 0; i < this.contentLocators.length; ++i) {
                if (this.contentLocators[i] == null) {
                    logger.info("There is no content collection given for the " + i + "-th collection");
                    contentReaders[i] = null;
                    continue;
                }
                contentReaders[i] = new ForwardReader(this.contentLocators[i]);
            }
            ForwardReader[][] metaReaders = new ForwardReader[this.metaLocators.length][];
            for (int i = 0; i < this.metaLocators.length; ++i) {
                if (this.metaLocators[i] == null) {
                    logger.info("There are no metadata collections given for the " + i + "-th collection");
                    metaReaders[i] = null;
                    continue;
                }
                metaReaders[i] = new ForwardReader[this.metaLocators[i].length];
                for (int j = 0; j < this.metaLocators[i].length; ++j) {
                    if (this.metaLocators[i][j] == null) {
                        throw new Exception("The locator for the " + j + "-th metadata collection of the " + i + "-th collection is null.");
                    }
                    metaReaders[i][j] = new ForwardReader(this.metaLocators[i][j]);
                }
            }
            this.stats.timeToInitialize(Calendar.getInstance().getTimeInMillis() - startInit);
            RecordWriter writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), new RecordDefinition[]{new GenericRecordDefinition(new FieldDefinition[]{new StringFieldDefinition(this.objectIdFieldName), new StringFieldDefinition(this.collectionFieldName), new StringFieldDefinition(this.rankFieldName)})}, 100, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor);
            IndexFuseWorker worker = new IndexFuseWorker((RecordWriter<Record>)writer, contentReaders, metaReaders, this.colIDs, this.contentWeight, this.metaWeight, this.objectIdFieldName, this.collectionFieldName, this.rankFieldName, this.timeout, this.timeUnit, this.stats);
            logger.info("Starting worker to perform the index fuse operation");
            worker.start();
            return writer.getLocator();
        }
        catch (Exception e) {
            logger.error("Could not initialize index fuse operation. Throwing Exception", (Throwable)e);
            throw new Exception("Could not initialize index fuse operation");
        }
    }
}

