/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.indexfuse;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.indexfuse.JoinElement;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.indexfuse.ReaderScan;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.indexfuse.ResultElement;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.indexfuse.ScanElement;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexFuseWorker
extends Thread {
    private static Logger logger = LoggerFactory.getLogger((String)IndexFuseWorker.class.getName());
    private double weightContent = 0.5;
    private double weightMetadata = 0.5;
    private ForwardReader<Record>[] contentReaders = null;
    private int[] actualCols = null;
    private ForwardReader[][] metaReaders = null;
    private int numOfCols;
    private RecordWriter<Record> writer = null;
    private String objectIdFieldName = null;
    private String collectionFieldName = null;
    private String rankFieldName = null;
    private Object synchThis = null;
    private long timeout;
    private TimeUnit timeUnit = null;
    private int count = 0;
    private long firststop = 0L;
    private StatsContainer stats;
    private String[] colIDs = null;

    public IndexFuseWorker(RecordWriter<Record> writer, ForwardReader<Record>[] contentReaders, ForwardReader<Record>[][] metaReaders, String[] colIDs, double weightContent, double weightMetadata, String objectIdFieldName, String collectionFieldName, String rankFieldName, long timeout, TimeUnit timeUnit, StatsContainer stats) {
        this.contentReaders = contentReaders;
        this.metaReaders = metaReaders;
        this.writer = writer;
        this.weightContent = weightContent;
        this.weightMetadata = weightMetadata;
        this.objectIdFieldName = objectIdFieldName;
        this.collectionFieldName = collectionFieldName;
        this.rankFieldName = rankFieldName;
        this.colIDs = colIDs;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.synchThis = new Object();
        this.stats = stats;
        this.numOfCols = contentReaders.length;
        this.actualCols = new int[contentReaders.length];
        for (int i = 0; i < this.actualCols.length; ++i) {
            this.actualCols[i] = 0;
            if (contentReaders[i] != null) {
                int n = i;
                this.actualCols[n] = this.actualCols[n] + 1;
            }
            if (metaReaders[i] != null) {
                int n = i;
                this.actualCols[n] = this.actualCols[n] + metaReaders[i].length;
            }
            logger.info(this.actualCols[i] + " content+metadata collections will participate for the results of the " + i + "-th collection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long start = Calendar.getInstance().getTimeInMillis();
        try {
            int i;
            LinkedList<JoinElement> queue = new LinkedList<JoinElement>();
            ScanElement[] contentScans = new ScanElement[this.numOfCols];
            ScanElement[][] metaScans = new ScanElement[this.numOfCols][];
            for (int i2 = 0; i2 < this.numOfCols; ++i2) {
                if (this.contentReaders[i2] == null) {
                    contentScans[i2] = null;
                } else {
                    contentScans[i2] = new ScanElement(this.contentReaders[i2], queue, this.synchThis, (short)i2, 0, this.timeout, this.timeUnit);
                    ReaderScan scan = new ReaderScan(contentScans[i2], this.objectIdFieldName, this.collectionFieldName, this.rankFieldName);
                    logger.info("Starting scanner for the content of the " + i2 + "-th collection");
                    scan.start();
                }
                if (this.metaReaders[i2] == null) {
                    metaScans[i2] = null;
                    continue;
                }
                metaScans[i2] = new ScanElement[this.metaReaders[i2].length];
                for (int j = 0; j < this.metaReaders[i2].length; ++j) {
                    metaScans[i2][j] = new ScanElement((ForwardReader<Record>)this.metaReaders[i2][j], queue, this.synchThis, (short)i2, (short)(j + 1), this.timeout, this.timeUnit);
                    ReaderScan scan = new ReaderScan(metaScans[i2][j], this.objectIdFieldName, this.collectionFieldName, this.rankFieldName);
                    logger.info("Starting scanner for the " + j + "-th metadata col of the " + i2 + "-th collection");
                    scan.start();
                }
            }
            JoinElement tmp = null;
            ArrayList<HashMap<String, ResultElement>> results = new ArrayList<HashMap<String, ResultElement>>(this.numOfCols);
            for (int i3 = 0; i3 < this.numOfCols; ++i3) {
                results.add(new HashMap());
            }
            LinkedList<Double> ranks = new LinkedList<Double>();
            LinkedList<String> ids = new LinkedList<String>();
            LinkedList<String> cols = new LinkedList<String>();
            long now = Calendar.getInstance().getTimeInMillis();
            logger.info("Retrieving entries from global queue while scanning RSs");
            while (true) {
                Object object = this.synchThis;
                synchronized (object) {
                    if (this.scanFinished(contentScans, metaScans)) {
                        logger.info("All the scanners completed their work");
                        break;
                    }
                    tmp = (JoinElement)queue.poll();
                    if (tmp == null) {
                        this.synchThis.wait(2000L);
                    }
                }
                if (tmp == null) continue;
                if (this.count == 0) {
                    this.stats.timeToFirstInput(Calendar.getInstance().getTimeInMillis() - now);
                }
                logger.info("Retrieved entry from queue for the " + tmp.getCollectionID() + "-th collection content/metadata:" + tmp.getMetaColID() + " while scanning RSs");
                this.checkJoin(tmp, results, ranks, ids, cols);
            }
            for (i = 0; i < contentScans.length; ++i) {
                if (contentScans[i] != null && contentScans[i].getCounter() == 0L) {
                    int n = i;
                    this.actualCols[n] = this.actualCols[n] - 1;
                    logger.info("There were no results retrieved from the content RS of the " + i + "-th collection");
                }
                if (metaScans[i] == null) continue;
                for (int j = 0; j < metaScans[i].length; ++j) {
                    if (metaScans[i][j].getCounter() != 0L) continue;
                    int n = i;
                    this.actualCols[n] = this.actualCols[n] - 1;
                    logger.info("There were no results retrieved from the " + j + "-th metadata RS of the " + i + "-th collection");
                }
            }
            for (i = 0; i < contentScans.length; ++i) {
                int initialCols = 0;
                if (contentScans[i] != null) {
                    ++initialCols;
                }
                if (metaScans[i] != null) {
                    initialCols += metaScans[i].length;
                }
                if (this.actualCols[i] >= initialCols) continue;
                logger.info("Checking if there are results ready to be sent for the " + i + "-th collection");
                for (ResultElement res : results.get(i).values()) {
                    logger.info("Result for OID:" + res.getId() + " Rank:" + res.getRank() + " has " + res.getInserted() + " elements inserted");
                    if (res.getInserted() != this.actualCols[i]) continue;
                    if (this.count == 0) {
                        this.firststop = Calendar.getInstance().getTimeInMillis();
                    }
                    ++this.count;
                    int index = Collections.binarySearch(ranks, -1.0 * res.getRank());
                    if (index < 0) {
                        index = -index - 1;
                    }
                    ranks.add(index, -1.0 * res.getRank());
                    ids.add(index, res.getId());
                    cols.add(index, this.colIDs[i]);
                    res.tagSent();
                    logger.info("Result for OID:" + res.getId() + " Rank:" + res.getRank() + " included in the sorted list");
                }
            }
            logger.info("Reading the rest of the global queue");
            tmp = (JoinElement)queue.poll();
            while (tmp != null) {
                this.checkJoin(tmp, results, ranks, ids, cols);
                tmp = (JoinElement)queue.poll();
            }
            logger.info("Sending the rest of the results");
            for (i = 0; i < contentScans.length; ++i) {
                for (ResultElement res : results.get(i).values()) {
                    logger.info("Result for OID:" + res.getId() + " Rank:" + res.getRank() + " isSent:" + res.isSent() + " has " + res.getInserted() + " elements inserted");
                    if (res.getInserted() >= this.actualCols[i]) continue;
                    if (this.count == 0) {
                        this.firststop = Calendar.getInstance().getTimeInMillis();
                    }
                    ++this.count;
                    int index = Collections.binarySearch(ranks, -1.0 * res.getRank());
                    if (index < 0) {
                        index = -index - 1;
                    }
                    ranks.add(index, -1.0 * res.getRank());
                    ids.add(index, res.getId());
                    cols.add(index, this.colIDs[i]);
                    res.tagSent();
                    logger.info("Result for OID:" + res.getId() + " Rank:" + res.getRank() + " included in the sorted list");
                }
            }
            logger.info("Writing results to RS");
            long startWriting = Calendar.getInstance().getTimeInMillis();
            String id = ids.poll();
            while (id != null) {
                if (this.writer.getStatus() == IBuffer.Status.Close || this.writer.getStatus() == IBuffer.Status.Dispose) {
                    logger.info("Consumer side stopped consumption. Stopping.");
                    break;
                }
                double rank = -1.0 * ranks.poll();
                String colID = cols.poll();
                GenericRecord outRec = new GenericRecord();
                Field[] fields = new Field[]{new StringField(id), new StringField(colID), new StringField(String.valueOf(rank))};
                outRec.setFields(fields);
                if (!this.writer.put((Record)outRec, this.timeout, this.timeUnit)) {
                    if (this.writer.getStatus() != IBuffer.Status.Open) break;
                    logger.warn("Consumer has timed out");
                    break;
                }
                logger.info("Added record:" + fields[0] + " " + fields[1] + " " + fields[2]);
                id = ids.poll();
            }
            long stopWriting = Calendar.getInstance().getTimeInMillis();
            logger.info("Finished writing output RS. Time(millisecs) needed was:" + (stopWriting - startWriting));
            try {
                this.writer.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.closeReaders((IRecordReader[])this.contentReaders, (IRecordReader[][])this.metaReaders);
            long closestop = Calendar.getInstance().getTimeInMillis();
            this.stats.timeToComplete(closestop - start);
            this.stats.timeToFirst(this.firststop - start);
            this.stats.productionRate((float)this.count / (float)(closestop - start) * 1000.0f);
            this.stats.producedResults(this.count);
            logger.info("INDEX FUSE OPERATOR:Produced first result in " + (this.firststop - start) + " milliseconds\n" + "Produced last result in " + (closestop - start) + " milliseconds\n" + "Produced " + this.count + " results\n" + "Production rate was " + (float)this.count / (float)(closestop - start) * 1000.0f + " records per second");
        }
        catch (Exception e) {
            logger.error("Error while background index fusing. Closing", (Throwable)e);
            try {
                this.writer.close();
            }
            catch (Exception ee) {
                // empty catch block
            }
            this.closeReaders((IRecordReader[])this.contentReaders, (IRecordReader[][])this.metaReaders);
        }
    }

    private boolean scanFinished(ScanElement[] contentScans, ScanElement[][] metaScans) {
        int i;
        for (i = 0; i < contentScans.length; ++i) {
            if (contentScans[i] == null || !contentScans[i].isActive()) continue;
            return false;
        }
        for (i = 0; i < metaScans.length; ++i) {
            if (metaScans[i] == null) continue;
            for (int j = 0; j < metaScans[i].length; ++j) {
                if (!metaScans[i][j].isActive()) continue;
                return false;
            }
        }
        return true;
    }

    private void closeReaders(IRecordReader[] contentReaders, IRecordReader[][] metaReaders) {
        for (int i = 0; i < this.numOfCols; ++i) {
            if (contentReaders[i] != null) {
                try {
                    contentReaders[i].close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (metaReaders[i] == null) continue;
            for (int j = 0; j < metaReaders[i].length; ++j) {
                try {
                    metaReaders[i][j].close();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    private void checkJoin(JoinElement tmp, ArrayList<HashMap<String, ResultElement>> results, LinkedList<Double> ranks, LinkedList<String> ids, LinkedList<String> cols) {
        try {
            String id = tmp.getId();
            short collection = tmp.getCollectionID();
            double weightContent = this.weightContent;
            double weightMetadata = this.weightMetadata;
            if (!results.get(collection).containsKey(id)) {
                logger.info("This is the first element for OID:" + id);
                if (this.metaReaders[collection] == null && this.contentReaders[collection] == null) {
                    throw new Exception("Undefined Server Error!");
                }
                if (this.metaReaders[collection] == null) {
                    weightContent = 1.0;
                    ResultElement res = new ResultElement(id, 0);
                    if (tmp.getMetaColID() != 0) {
                        throw new Exception("Undefined Server Error! There is no metadata for the " + collection + "-th collection");
                    }
                    res.insertElement(tmp, weightContent);
                    res.tagSent();
                    results.get(collection).put(id, res);
                    if (this.count == 0) {
                        this.firststop = Calendar.getInstance().getTimeInMillis();
                    }
                    ++this.count;
                    int index = Collections.binarySearch(ranks, -1.0 * res.getRank());
                    if (index < 0) {
                        index = -index - 1;
                    }
                    ranks.add(index, -1.0 * res.getRank());
                    ids.add(index, id);
                    cols.add(index, this.colIDs[collection]);
                    logger.info("Result for OID:" + res.getId() + " Rank:" + res.getRank() + " included in the sorted list");
                } else if (this.contentReaders[collection] == null) {
                    weightMetadata = 1.0;
                    ResultElement res = new ResultElement(id, this.metaReaders[collection].length);
                    if (tmp.getMetaColID() == 0) {
                        throw new Exception("Undefined Server Error! There is no content for the " + collection + "-th collection");
                    }
                    res.insertElement(tmp, weightMetadata / (double)this.metaReaders[collection].length);
                    logger.info("Result for OID:" + res.getId() + " has new Rank:" + res.getRank());
                    if (this.actualCols[collection] == res.getInserted()) {
                        if (this.count == 0) {
                            this.firststop = Calendar.getInstance().getTimeInMillis();
                        }
                        ++this.count;
                        int index = Collections.binarySearch(ranks, -1.0 * res.getRank());
                        if (index < 0) {
                            index = -index - 1;
                        }
                        ranks.add(index, -1.0 * res.getRank());
                        ids.add(index, id);
                        cols.add(index, this.colIDs[collection]);
                        res.tagSent();
                        logger.info("Result for OID:" + res.getId() + " Rank:" + res.getRank() + " included in the sorted list");
                    }
                    results.get(collection).put(id, res);
                } else {
                    ResultElement res = new ResultElement(id, this.metaReaders[collection].length);
                    if (tmp.getMetaColID() == 0) {
                        res.insertElement(tmp, weightContent);
                    } else {
                        res.insertElement(tmp, weightMetadata / (double)this.metaReaders[collection].length);
                    }
                    logger.info("Result for OID:" + res.getId() + " has new Rank:" + res.getRank());
                    if (this.actualCols[collection] == res.getInserted()) {
                        if (this.count == 0) {
                            this.firststop = Calendar.getInstance().getTimeInMillis();
                        }
                        ++this.count;
                        int index = Collections.binarySearch(ranks, -1.0 * res.getRank());
                        if (index < 0) {
                            index = -index - 1;
                        }
                        ranks.add(index, -1.0 * res.getRank());
                        ids.add(index, id);
                        cols.add(index, this.colIDs[collection]);
                        res.tagSent();
                        logger.info("Result for OID:" + res.getId() + " Rank:" + res.getRank() + " included in the sorted list");
                    }
                    results.get(collection).put(id, res);
                }
            } else {
                ResultElement res = results.get(collection).get(id);
                logger.info("There is already an element for OID:" + id + " with Rank:" + res.getRank());
                if (res.isSent()) {
                    return;
                }
                if (this.contentReaders[collection] == null) {
                    weightMetadata = 1.0;
                }
                boolean inserted = tmp.getMetaColID() == 0 ? res.insertElement(tmp, weightContent) : res.insertElement(tmp, weightMetadata / (double)this.metaReaders[collection].length);
                logger.info("Result for OID:" + res.getId() + " has new Rank:" + res.getRank());
                if (this.actualCols[collection] == res.getInserted() && inserted) {
                    if (this.count == 0) {
                        this.firststop = Calendar.getInstance().getTimeInMillis();
                    }
                    ++this.count;
                    int index = Collections.binarySearch(ranks, -1.0 * res.getRank());
                    if (index < 0) {
                        index = -index - 1;
                    }
                    ranks.add(index, -1.0 * res.getRank());
                    ids.add(index, id);
                    cols.add(index, this.colIDs[collection]);
                    res.tagSent();
                    logger.info("Result for OID:" + res.getId() + " Rank:" + res.getRank() + " included in the sorted list");
                }
                results.get(collection).put(id, res);
            }
        }
        catch (Exception e) {
            logger.error("Could not check join. Continuing", (Throwable)e);
        }
    }
}

