/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.indexfuse;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.indexfuse.JoinElement;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.indexfuse.ScanElement;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderScan
extends Thread {
    private static Logger logger = LoggerFactory.getLogger((String)ReaderScan.class.getName());
    ScanElement scan = null;
    String objectIdFieldName = null;
    String collectionFieldName = null;
    String rankFieldName = null;

    public ReaderScan(ScanElement scan, String objectIdFieldName, String collectionFieldName, String rankFieldName) {
        this.scan = scan;
        this.objectIdFieldName = objectIdFieldName;
        this.collectionFieldName = collectionFieldName;
        this.rankFieldName = rankFieldName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block28: {
            try {
                long timeout = 0L;
                TimeUnit timeUnit = null;
                Object object = this.scan.getSynchThis();
                synchronized (object) {
                    this.scan.setActive(true);
                    this.scan.getSynchThis().notify();
                    timeout = this.scan.getTimeout();
                    timeUnit = this.scan.getTimeUnit();
                }
                ForwardReader<Record> reader = this.scan.getReader();
                long currentRecordIndex = 0L;
                while (true) {
                    try {
                        double rank;
                        String value;
                        do {
                            Record tmp;
                            if ((tmp = reader.get(timeout, timeUnit)) == null) {
                                if (reader.getStatus() == IBuffer.Status.Open) {
                                    logger.warn("Producer has timed out");
                                }
                                break block28;
                            }
                            currentRecordIndex = reader.currentRecord();
                            value = null;
                            rank = 0.0;
                            try {
                                value = ((StringField)tmp.getField(this.objectIdFieldName)).getPayload();
                                rank = Double.parseDouble(((StringField)tmp.getField(this.rankFieldName)).getPayload());
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        } while (value == null);
                        Object object2 = this.scan.getSynchThis();
                        synchronized (object2) {
                            this.scan.setCounter(this.scan.getCounter() + 1L);
                            this.scan.getQueue().offer(new JoinElement(value, rank, this.scan.getInputID(), this.scan.getMetaInputID()));
                            this.scan.getSynchThis().notifyAll();
                            continue;
                        }
                    }
                    catch (Exception e) {
                        logger.error("Could not retrieve the record. Continuing", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.error("Could not scan entire reader. Closing", (Throwable)e);
            }
            finally {
                Object object = this.scan.getSynchThis();
                synchronized (object) {
                    this.scan.setActive(false);
                    this.scan.getSynchThis().notifyAll();
                }
            }
        }
    }
}

