/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge;

import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.Pair;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.ReaderScan;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.RecordBufferEntry;
import java.util.HashSet;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sorter
extends Thread {
    private Logger logger = LoggerFactory.getLogger((String)ReaderScan.class.getName());
    private BlockingQueue<RecordBufferEntry> buf;
    private ReaderScan[] scan;

    public Sorter(ReaderScan[] scan, BlockingQueue<RecordBufferEntry> buf) {
        this.scan = scan;
        this.buf = buf;
    }

    @Override
    public void run() {
        HashSet<Integer> readersFinished = new HashSet<Integer>(this.scan.length);
        while (true) {
            int minRank = -2;
            int index = -1;
            for (int i = 0; i < this.scan.length; ++i) {
                if (readersFinished.contains(i)) continue;
                Pair<RecordBufferEntry, Integer> rr = this.scan[i].peek();
                if (rr != null) {
                    RecordBufferEntry rec = rr.getFirst();
                    if (rec.id < 0) {
                        readersFinished.add(i);
                        continue;
                    }
                    if (index >= 0 && rr.getSecond() >= minRank) continue;
                    minRank = rr.getSecond();
                    index = i;
                    continue;
                }
                --i;
            }
            if (readersFinished.size() == this.scan.length) break;
            try {
                this.buf.put(this.scan[index].poll().getFirst());
            }
            catch (InterruptedException e) {
                this.logger.error("Could not put record into buffer", (Throwable)e);
            }
        }
    }
}

