/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.sort;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.RandomReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.comparator.CompareTokens;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.comparator.ComparisonMode;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.sort.SortArrayElement;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.sort.SortWorker;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.utils.ComparisonMethod;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineSortWorker<T extends Record>
implements SortWorker {
    private static Logger logger = LoggerFactory.getLogger((String)OnlineSortWorker.class.getName());
    private IRecordWriter<Record> writer = null;
    URI outLocator = null;
    private RandomReader<T> reader = null;
    private String keyFieldName = null;
    private short order = 0;
    private StatsContainer stats = null;
    private ComparisonMethod method = null;
    private long timeout;
    private TimeUnit timeUnit;

    public OnlineSortWorker(RandomReader<T> reader, IRecordWriter<Record> writer, String keyFieldName, short order, ComparisonMethod method, ComparisonMode mode, long timeout, TimeUnit timeUnit, StatsContainer stats) throws Exception {
        this.reader = reader;
        reader.setWindowSize(1);
        this.writer = writer;
        this.keyFieldName = keyFieldName;
        this.order = order;
        this.stats = stats;
        this.method = method;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        logger.info("Comparison method: " + (Object)((Object)this.method));
        if (method == ComparisonMethod.DETECT_MODE) {
            logger.error("Unsupported comparison mode. Throwing exception");
            throw new Exception("Unsupported comparison mode");
        }
        if (method == ComparisonMethod.PROVIDED_MODE) {
            if (mode == null) {
                mode = ComparisonMode.COMPARE_STRINGS;
                CompareTokens.setMode(ComparisonMode.COMPARE_STRINGS);
                logger.warn("Missing mode. Assuming string comparison.");
            } else {
                CompareTokens.setMode(mode);
            }
            logger.info("Comparison mode: " + (Object)((Object)CompareTokens.getMode()));
        }
    }

    private int locateInsertionPosition(List<SortArrayElement> sortVector, String value) throws Exception {
        int lBound = 0;
        int rBound = sortVector.size() - 1;
        int pos = 0;
        while (lBound <= rBound) {
            pos = (int)Math.floor((float)(rBound + lBound) / 2.0f);
            boolean cmp = false;
            if (this.order == 0) {
                if (this.method == ComparisonMethod.FULL_COMPARISON) {
                    if (CompareTokens.compare(value, sortVector.get((int)pos).value) > 0) {
                        cmp = true;
                    }
                } else if (CompareTokens.compare(value, sortVector.get((int)pos).value, CompareTokens.getMode()) > 0) {
                    cmp = true;
                }
            } else if (this.method == ComparisonMethod.FULL_COMPARISON) {
                if (CompareTokens.compare(value, sortVector.get((int)pos).value) < 0) {
                    cmp = true;
                }
            } else if (CompareTokens.compare(value, sortVector.get((int)pos).value, CompareTokens.getMode()) < 0) {
                cmp = true;
            }
            if (cmp) {
                lBound = pos + 1;
                continue;
            }
            rBound = pos - 1;
        }
        return lBound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long start = Calendar.getInstance().getTimeInMillis();
        int count = 0;
        int rc = 0;
        try {
            Record rec;
            long now;
            ArrayList<SortArrayElement> appendVector;
            ArrayList<SortArrayElement> sortVector;
            block38: {
                sortVector = new ArrayList<SortArrayElement>();
                appendVector = new ArrayList<SortArrayElement>();
                now = Calendar.getInstance().getTimeInMillis();
                long rfnow = Calendar.getInstance().getTimeInMillis();
                do {
                    Record record;
                    if ((record = this.reader.get(this.timeout, this.timeUnit)) == null) {
                        if (this.reader.getStatus() == IBuffer.Status.Open) {
                            logger.warn("Producer has timed out");
                        }
                        break block38;
                    }
                    ++rc;
                    String value = null;
                    try {
                        if (rc == 1) {
                            logger.info("Time to first input: " + (Calendar.getInstance().getTimeInMillis() - rfnow));
                            this.stats.timeToFirstInput(Calendar.getInstance().getTimeInMillis() - rfnow);
                        }
                        try {
                            Field key = record.getField(this.keyFieldName);
                            if (key instanceof StringField) {
                                value = ((StringField)key).getPayload();
                            }
                        }
                        catch (Exception e) {
                            logger.warn("Could not extract sort key from record #" + rc + ". Continuing");
                        }
                        if (value == null) {
                            appendVector.add(new SortArrayElement(this.reader.currentRecord(), null));
                            continue;
                        }
                        int pos = this.locateInsertionPosition(sortVector, value);
                        sortVector.add(pos, new SortArrayElement(this.reader.currentRecord(), value));
                    }
                    catch (Exception e) {
                        logger.error("Could not retrieve the record. Continuing", (Throwable)e);
                    }
                } while (this.writer.getStatus() != IBuffer.Status.Close && this.writer.getStatus() != IBuffer.Status.Dispose);
                logger.info("Consumer side stopped consumption. Stopping.");
            }
            logger.info("retrieving of results and online sorting took " + (Calendar.getInstance().getTimeInMillis() - now));
            now = Calendar.getInstance().getTimeInMillis();
            long firststop = 0L;
            rc = 0;
            Iterator it = sortVector.iterator();
            while (it.hasNext()) {
                try {
                    ++count;
                    this.reader.seek(-this.reader.currentRecord() + ((SortArrayElement)it.next()).index - 1L);
                    rec = this.reader.get();
                    if (rec == null) {
                        throw new Exception("Could not retrieve stored record");
                    }
                    if (this.writer.getStatus() == IBuffer.Status.Close || this.writer.getStatus() == IBuffer.Status.Dispose) {
                        logger.info("Consumer side stopped consumption. Stopping.");
                        break;
                    }
                    if (!this.writer.put(rec, this.timeout, this.timeUnit)) {
                        if (this.writer.getStatus() != IBuffer.Status.Open) break;
                        logger.warn("Consumer has timed out");
                        break;
                    }
                    if (++rc != 1) continue;
                    firststop = Calendar.getInstance().getTimeInMillis();
                }
                catch (Exception e) {
                    logger.info("Could not write record " + count, (Throwable)e);
                }
            }
            it = appendVector.iterator();
            while (it.hasNext()) {
                try {
                    ++count;
                    this.reader.seek(((SortArrayElement)it.next()).index);
                    rec = this.reader.get();
                    if (this.writer.getStatus() == IBuffer.Status.Close || this.writer.getStatus() == IBuffer.Status.Dispose) {
                        logger.info("Consumer side stopped consumption. Stopping.");
                        break;
                    }
                    if (!this.writer.put(rec, this.timeout, this.timeUnit)) {
                        if (this.writer.getStatus() != IBuffer.Status.Open) break;
                        logger.warn("Consumer has timed out");
                        break;
                    }
                    if (++rc != 1) continue;
                    firststop = Calendar.getInstance().getTimeInMillis();
                }
                catch (Exception e) {
                    logger.warn("Could not write record" + count, (Throwable)e);
                }
            }
            logger.info("SORT: writing results took " + (Calendar.getInstance().getTimeInMillis() - now));
            long closestop = Calendar.getInstance().getTimeInMillis();
            this.stats.timeToComplete(closestop - start);
            this.stats.timeToFirst(firststop - start);
            this.stats.producedResults(rc);
            this.stats.productionRate((float)rc / (float)(closestop - start) * 1000.0f);
            logger.info("SORT OPERATOR:\nProduced " + rc + " results" + "\nProduced first result in " + (firststop - start) + " milliseconds\n" + "Produced last result in " + (closestop - start) + " milliseconds\n" + "Production rate was " + (float)rc / (float)(closestop - start) * 1000.0f + " records per second");
        }
        catch (Exception e) {
            logger.error("Error while background sorting. Closing", (Throwable)e);
        }
        finally {
            try {
                try {
                    this.reader.close();
                    this.writer.close();
                }
                catch (Exception ee) {}
            }
            catch (Exception ee) {
                logger.error("Error while closing. ", (Throwable)ee);
            }
        }
    }
}

