/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.sort;

import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.reader.RandomReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.comparator.ComparisonMode;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.sort.OfflineSortWorker;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.sort.OnlineSortWorker;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.sort.SortAlgorithm;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.sort.SortWorker;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.utils.ComparisonMethod;
import java.net.URI;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortOp {
    private static Logger logger = LoggerFactory.getLogger((String)SortOp.class.getName());
    private URI inLocator = null;
    private StatsContainer stats = null;
    private static final long TimeoutDef = 60L;
    private static final TimeUnit TimeUnitDef = TimeUnit.SECONDS;
    private long timeout = 60L;
    private TimeUnit timeUnit = TimeUnitDef;

    public SortOp(URI inLocator, StatsContainer stats) {
        this.inLocator = inLocator;
        this.stats = stats;
    }

    public SortOp(URI inLocator, StatsContainer stats, long timeout, TimeUnit timeUnit) {
        this(inLocator, stats);
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    public URI compute(String key, short order) throws Exception {
        return this.compute(key, order, ComparisonMethod.FULL_COMPARISON, null, SortAlgorithm.OFFLINE);
    }

    public URI compute(String keyFieldName, short order, ComparisonMethod comparisonMethod, ComparisonMode comparisonMode, SortAlgorithm algorithm) throws Exception {
        try {
            long readerstart = Calendar.getInstance().getTimeInMillis();
            RandomReader reader = new RandomReader(this.inLocator);
            RecordWriter writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), (IRecordReader)reader);
            SortWorker worker = null;
            worker = algorithm == SortAlgorithm.OFFLINE ? new OfflineSortWorker(reader, (IRecordWriter<Record>)writer, keyFieldName, order, comparisonMethod, comparisonMode, this.timeout, this.timeUnit, this.stats) : new OnlineSortWorker(reader, (IRecordWriter<Record>)writer, keyFieldName, order, comparisonMethod, comparisonMode, this.timeout, this.timeUnit, this.stats);
            new Thread(worker).start();
            long readerstop = Calendar.getInstance().getTimeInMillis();
            logger.info("Time to initialize: " + (readerstop - readerstart));
            this.stats.timeToInitialize(readerstop - readerstart);
            return writer.getLocator();
        }
        catch (Exception e) {
            logger.error("Could not start background process of sort. Throwing Exception", (Throwable)e);
            throw new Exception("Could not start background process of sort");
        }
    }

    public static void main(String[] args) throws Exception {
    }
}

