/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.transform;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class CommandExecutor {
    private Process proc;
    private String command;
    private InputStream sErr;
    private OutputStream sIn;
    private InputStream sOut;
    private BufferedReader br;
    private BufferedWriter bw;

    public CommandExecutor(String command) {
        this.command = command;
    }

    public void execute() throws IOException, InterruptedException {
        this.proc = Runtime.getRuntime().exec(this.command);
        this.sErr = this.proc.getErrorStream();
        this.sIn = this.proc.getOutputStream();
        this.sOut = this.proc.getInputStream();
        this.br = new BufferedReader(new InputStreamReader(this.sOut));
        this.bw = new BufferedWriter(new OutputStreamWriter(this.sIn));
        new Thread(){

            @Override
            public void run() {
                CommandExecutor.pipe(CommandExecutor.this.sErr, System.err);
            }
        }.start();
    }

    public void transform(String str) throws IOException {
        this.bw.write(str);
        this.bw.newLine();
    }

    public int waitFor() throws IOException, InterruptedException {
        return this.proc.waitFor();
    }

    public int exitValue() throws IllegalThreadStateException {
        return this.proc.exitValue();
    }

    public void finishedWriting() throws IOException {
        this.bw.flush();
        this.bw.close();
        this.sIn.close();
    }

    public void finishedReading() throws IOException {
        this.br.close();
        this.sOut.close();
    }

    public BufferedReader getBufferedReader() {
        return this.br;
    }

    public static void pipe(InputStream in, OutputStream out) {
        try {
            int i = -1;
            byte[] buf = new byte[1024];
            while ((i = in.read(buf)) != -1) {
                out.write(buf, 0, i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void test() {
        try {
            CommandExecutor.maain(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        CommandExecutor.test();
        System.out.println("Total time: " + (System.currentTimeMillis() - start));
    }

    public static void maain(String[] args) throws IOException, InterruptedException {
        final CommandExecutor exec = new CommandExecutor("python /home/jgerbe/Desktop/datasets/wiki/multi/counter.py");
        try {
            String line;
            exec.execute();
            new Thread(){

                @Override
                public void run() {
                    try {
                        String line;
                        BufferedReader br = new BufferedReader(new FileReader("/home/jgerbe/Desktop/datasets/wiki/multi/input.dat.10"));
                        int i = 0;
                        while ((line = br.readLine()) != null) {
                            System.out.println("in: " + line);
                            String[] ls = line.split("\t");
                            line = ls[0] + "\t" + ls[2] + "\t" + ls[3] + "\t";
                            exec.transform(line);
                            if (++i % 1000 != 0) continue;
                            System.out.println(i);
                        }
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        exec.finishedWriting();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
            BufferedReader br = exec.getBufferedReader();
            BufferedWriter bw = new BufferedWriter(new FileWriter(new File("/home/jgerbe/Desktop/output.dat")));
            boolean i = false;
            while ((line = br.readLine()) != null) {
                System.out.println("out: " + line);
                bw.write(line);
                bw.newLine();
            }
            exec.finishedReading();
            System.out.println(exec.waitFor());
            bw.flush();
            bw.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }
}

